/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDocument.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "Element.h"
#include "HTMLCollection.h"
#include "HTMLDocument.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLDocumentTableEntries[] =
{
    { "bgColor", { (intptr_t)JSHTMLDocument::BgColorAttrNum }, DontDelete, 0, &JSHTMLDocumentTableEntries[34] },
    { 0, { 0 }, 0, 0, 0 },
    { "alinkColor", { (intptr_t)JSHTMLDocument::AlinkColorAttrNum }, DontDelete, 0, 0 },
    { "width", { (intptr_t)JSHTMLDocument::WidthAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "plugins", { (intptr_t)JSHTMLDocument::PluginsAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "height", { (intptr_t)JSHTMLDocument::HeightAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "fgColor", { (intptr_t)JSHTMLDocument::FgColorAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "vlinkColor", { (intptr_t)JSHTMLDocument::VlinkColorAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "all", { (intptr_t)JSHTMLDocument::AllAttrNum }, 0, 0, 0 },
    { "embeds", { (intptr_t)JSHTMLDocument::EmbedsAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLDocumentTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scripts", { (intptr_t)JSHTMLDocument::ScriptsAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLDocumentTableEntries[33] },
    { "compatMode", { (intptr_t)JSHTMLDocument::CompatModeAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLDocumentTableEntries[35] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "activeElement", { (intptr_t)JSHTMLDocument::ActiveElementAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "dir", { (intptr_t)JSHTMLDocument::DirAttrNum }, DontDelete, 0, 0 },
    { "designMode", { (intptr_t)JSHTMLDocument::DesignModeAttrNum }, DontDelete, 0, 0 },
    { "linkColor", { (intptr_t)JSHTMLDocument::LinkColorAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLDocument::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLDocumentTable = 
{
    3, 36, JSHTMLDocumentTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSHTMLDocumentConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentConstructorTable = 
{
    3, 1, JSHTMLDocumentConstructorTableEntries, 0
};

class JSHTMLDocumentConstructor : public DOMObject {
public:
    JSHTMLDocumentConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDocumentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLDocumentConstructor::info = { "HTMLDocumentConstructor", 0, &JSHTMLDocumentConstructorTable };

bool JSHTMLDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDocumentConstructor, DOMObject>(exec, &JSHTMLDocumentConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLDocumentConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLDocumentPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "hasFocus", { (intptr_t)jsHTMLDocumentPrototypeFunctionHasFocus }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "captureEvents", { (intptr_t)jsHTMLDocumentPrototypeFunctionCaptureEvents }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "writeln", { (intptr_t)jsHTMLDocumentPrototypeFunctionWriteln }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "close", { (intptr_t)jsHTMLDocumentPrototypeFunctionClose }, DontDelete|Function, 0, 0 },
    { "clear", { (intptr_t)jsHTMLDocumentPrototypeFunctionClear }, DontDelete|Function, 0, 0 },
    { "releaseEvents", { (intptr_t)jsHTMLDocumentPrototypeFunctionReleaseEvents }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "open", { (intptr_t)jsHTMLDocumentPrototypeFunctionOpen }, DontDelete|Function, 0, &JSHTMLDocumentPrototypeTableEntries[16] },
    { "write", { (intptr_t)jsHTMLDocumentPrototypeFunctionWrite }, DontDelete|Function, 1, 0 }
};

static const HashTable JSHTMLDocumentPrototypeTable = 
{
    3, 17, JSHTMLDocumentPrototypeTableEntries, 15
};

const ClassInfo JSHTMLDocumentPrototype::info = { "HTMLDocumentPrototype", 0, &JSHTMLDocumentPrototypeTable };

JSObject* JSHTMLDocumentPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLDocumentPrototype>(exec, "[[JSHTMLDocument.prototype]]");
}

bool JSHTMLDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLDocument::info = { "HTMLDocument", &JSDocument::info, &JSHTMLDocumentTable };

JSHTMLDocument::JSHTMLDocument(JSObject* prototype, HTMLDocument* impl)
    : JSDocument(prototype, impl)
{
}

bool JSHTMLDocument::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLDocument*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLDocument, Base>(exec, &JSHTMLDocumentTable, this, propertyName, slot);
}

JSValue* JSHTMLDocument::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case EmbedsAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return toJS(exec, WTF::getPtr(imp->embeds()));
    }
    case PluginsAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return toJS(exec, WTF::getPtr(imp->plugins()));
    }
    case ScriptsAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return toJS(exec, WTF::getPtr(imp->scripts()));
    }
    case AllAttrNum: {
        return all(exec);
    }
    case WidthAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsNumber(imp->width());
    }
    case HeightAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsNumber(imp->height());
    }
    case DirAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->dir());
    }
    case DesignModeAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->designMode());
    }
    case CompatModeAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->compatMode());
    }
    case ActiveElementAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return toJS(exec, WTF::getPtr(imp->activeElement()));
    }
    case BgColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->bgColor());
    }
    case FgColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->fgColor());
    }
    case AlinkColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->alinkColor());
    }
    case LinkColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->linkColor());
    }
    case VlinkColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        return jsString(imp->vlinkColor());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLDocument::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLDocument, Base>(exec, propertyName, value, &JSHTMLDocumentTable, this);
}

void JSHTMLDocument::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AllAttrNum: {
        setAll(exec, value);
        break;
    }
    case DirAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setDir(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DesignModeAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setDesignMode(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BgColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setBgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case FgColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setFgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlinkColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setAlinkColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LinkColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setLinkColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VlinkColorAttrNum: {
        HTMLDocument* imp = static_cast<HTMLDocument*>(impl());
        imp->setVlinkColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLDocument::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLDocumentConstructor>(exec, "[[HTMLDocument.constructor]]");
}

JSValue* jsHTMLDocumentPrototypeFunctionOpen(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    return castedThisObj->open(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionClose(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionWrite(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    return castedThisObj->write(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionWriteln(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    return castedThisObj->writeln(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionClear(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    return castedThisObj->clear(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionCaptureEvents(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->captureEvents();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionReleaseEvents(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->releaseEvents();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionHasFocus(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLDocument::info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisObj);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());


    KJS::JSValue* result = jsBoolean(imp->hasFocus());
    return result;
}


}
