/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDListElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDListElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLDListElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLDListElement::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "compact", { (intptr_t)JSHTMLDListElement::CompactAttrNum }, DontDelete, 0, 0 }
};

static const HashTable JSHTMLDListElementTable = 
{
    3, 4, JSHTMLDListElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLDListElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementConstructorTable = 
{
    3, 1, JSHTMLDListElementConstructorTableEntries, 0
};

class JSHTMLDListElementConstructor : public DOMObject {
public:
    JSHTMLDListElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDListElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLDListElementConstructor::info = { "HTMLDListElementConstructor", 0, &JSHTMLDListElementConstructorTable };

bool JSHTMLDListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDListElementConstructor, DOMObject>(exec, &JSHTMLDListElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLDListElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLDListElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementPrototypeTable = 
{
    3, 1, JSHTMLDListElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLDListElementPrototype::info = { "HTMLDListElementPrototype", 0, &JSHTMLDListElementPrototypeTable };

JSObject* JSHTMLDListElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLDListElementPrototype>(exec, "[[JSHTMLDListElement.prototype]]");
}

const ClassInfo JSHTMLDListElement::info = { "HTMLDListElement", &JSHTMLElement::info, &JSHTMLDListElementTable };

JSHTMLDListElement::JSHTMLDListElement(JSObject* prototype, HTMLDListElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLDListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDListElement, Base>(exec, &JSHTMLDListElementTable, this, propertyName, slot);
}

JSValue* JSHTMLDListElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDListElement* imp = static_cast<HTMLDListElement*>(impl());
        return jsBoolean(imp->compact());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLDListElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLDListElement, Base>(exec, propertyName, value, &JSHTMLDListElementTable, this);
}

void JSHTMLDListElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDListElement* imp = static_cast<HTMLDListElement*>(impl());
        imp->setCompact(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSHTMLDListElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLDListElementConstructor>(exec, "[[HTMLDListElement.constructor]]");
}


}
