/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLCanvasElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCanvasElement.h"
#include "JSCanvasRenderingContext2D.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLCanvasElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "height", { (intptr_t)JSHTMLCanvasElement::HeightAttrNum }, DontDelete, 0, &JSHTMLCanvasElementTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { "width", { (intptr_t)JSHTMLCanvasElement::WidthAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLCanvasElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLCanvasElementTable = 
{
    3, 9, JSHTMLCanvasElementTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSHTMLCanvasElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLCanvasElementConstructorTable = 
{
    3, 1, JSHTMLCanvasElementConstructorTableEntries, 0
};

class JSHTMLCanvasElementConstructor : public DOMObject {
public:
    JSHTMLCanvasElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLCanvasElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLCanvasElementConstructor::info = { "HTMLCanvasElementConstructor", 0, &JSHTMLCanvasElementConstructorTable };

bool JSHTMLCanvasElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElementConstructor, DOMObject>(exec, &JSHTMLCanvasElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLCanvasElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLCanvasElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "getContext", { (intptr_t)jsHTMLCanvasElementPrototypeFunctionGetContext }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "toDataURL", { (intptr_t)jsHTMLCanvasElementPrototypeFunctionToDataURL }, DontDelete|Function, 1, 0 }
};

static const HashTable JSHTMLCanvasElementPrototypeTable = 
{
    3, 4, JSHTMLCanvasElementPrototypeTableEntries, 3
};

const ClassInfo JSHTMLCanvasElementPrototype::info = { "HTMLCanvasElementPrototype", 0, &JSHTMLCanvasElementPrototypeTable };

JSObject* JSHTMLCanvasElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLCanvasElementPrototype>(exec, "[[JSHTMLCanvasElement.prototype]]");
}

bool JSHTMLCanvasElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLCanvasElement::info = { "HTMLCanvasElement", &JSHTMLElement::info, &JSHTMLCanvasElementTable };

JSHTMLCanvasElement::JSHTMLCanvasElement(JSObject* prototype, HTMLCanvasElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLCanvasElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElement, Base>(exec, &JSHTMLCanvasElementTable, this, propertyName, slot);
}

JSValue* JSHTMLCanvasElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case WidthAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        return jsNumber(imp->width());
    }
    case HeightAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        return jsNumber(imp->height());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLCanvasElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLCanvasElement, Base>(exec, propertyName, value, &JSHTMLCanvasElementTable, this);
}

void JSHTMLCanvasElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case WidthAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        imp->setWidth(value->toInt32(exec));
        break;
    }
    case HeightAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        imp->setHeight(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLCanvasElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLCanvasElementConstructor>(exec, "[[HTMLCanvasElement.constructor]]");
}

JSValue* jsHTMLCanvasElementPrototypeFunctionToDataURL(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLCanvasElement::info))
        return throwError(exec, TypeError);
    JSHTMLCanvasElement* castedThisObj = static_cast<JSHTMLCanvasElement*>(thisObj);
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThisObj->impl());
    String type = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


    KJS::JSValue* result = jsString(imp->toDataURL(type));
    return result;
}

JSValue* jsHTMLCanvasElementPrototypeFunctionGetContext(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLCanvasElement::info))
        return throwError(exec, TypeError);
    JSHTMLCanvasElement* castedThisObj = static_cast<JSHTMLCanvasElement*>(thisObj);
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThisObj->impl());
    String contextId = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getContext(contextId)));
    return result;
}


}
