/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBodyElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBodyElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLBodyElementTableEntries[] =
{
    { "bgColor", { (intptr_t)JSHTMLBodyElement::BgColorAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollHeight", { (intptr_t)JSHTMLBodyElement::ScrollHeightAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "aLink", { (intptr_t)JSHTMLBodyElement::ALinkAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "text", { (intptr_t)JSHTMLBodyElement::TextAttrNum }, DontDelete, 0, 0 },
    { "scrollLeft", { (intptr_t)JSHTMLBodyElement::ScrollLeftAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollTop", { (intptr_t)JSHTMLBodyElement::ScrollTopAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "vLink", { (intptr_t)JSHTMLBodyElement::VLinkAttrNum }, DontDelete, 0, 0 },
    { "background", { (intptr_t)JSHTMLBodyElement::BackgroundAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollWidth", { (intptr_t)JSHTMLBodyElement::ScrollWidthAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLBodyElementTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { "link", { (intptr_t)JSHTMLBodyElement::LinkAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLBodyElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLBodyElementTable = 
{
    3, 33, JSHTMLBodyElementTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSHTMLBodyElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementConstructorTable = 
{
    3, 1, JSHTMLBodyElementConstructorTableEntries, 0
};

class JSHTMLBodyElementConstructor : public DOMObject {
public:
    JSHTMLBodyElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBodyElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBodyElementConstructor::info = { "HTMLBodyElementConstructor", 0, &JSHTMLBodyElementConstructorTable };

bool JSHTMLBodyElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElementConstructor, DOMObject>(exec, &JSHTMLBodyElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBodyElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLBodyElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementPrototypeTable = 
{
    3, 1, JSHTMLBodyElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLBodyElementPrototype::info = { "HTMLBodyElementPrototype", 0, &JSHTMLBodyElementPrototypeTable };

JSObject* JSHTMLBodyElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBodyElementPrototype>(exec, "[[JSHTMLBodyElement.prototype]]");
}

const ClassInfo JSHTMLBodyElement::info = { "HTMLBodyElement", &JSHTMLElement::info, &JSHTMLBodyElementTable };

JSHTMLBodyElement::JSHTMLBodyElement(JSObject* prototype, HTMLBodyElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLBodyElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElement, Base>(exec, &JSHTMLBodyElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBodyElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ALinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(imp->aLink());
    }
    case BackgroundAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(imp->background());
    }
    case BgColorAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(imp->bgColor());
    }
    case LinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(imp->link());
    }
    case TextAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(imp->text());
    }
    case VLinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(imp->vLink());
    }
    case ScrollLeftAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(imp->scrollLeft());
    }
    case ScrollTopAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(imp->scrollTop());
    }
    case ScrollWidthAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(imp->scrollWidth());
    }
    case ScrollHeightAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(imp->scrollHeight());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBodyElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLBodyElement, Base>(exec, propertyName, value, &JSHTMLBodyElementTable, this);
}

void JSHTMLBodyElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ALinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setALink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BackgroundAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setBackground(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BgColorAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setBgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setLink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TextAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VLinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setVLink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ScrollLeftAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setScrollLeft(value->toInt32(exec));
        break;
    }
    case ScrollTopAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setScrollTop(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLBodyElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBodyElementConstructor>(exec, "[[HTMLBodyElement.constructor]]");
}


}
