/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBRElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBRElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLBRElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLBRElement::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "clear", { (intptr_t)JSHTMLBRElement::ClearAttrNum }, DontDelete, 0, 0 }
};

static const HashTable JSHTMLBRElementTable = 
{
    3, 4, JSHTMLBRElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLBRElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLBRElementConstructorTable = 
{
    3, 1, JSHTMLBRElementConstructorTableEntries, 0
};

class JSHTMLBRElementConstructor : public DOMObject {
public:
    JSHTMLBRElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBRElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBRElementConstructor::info = { "HTMLBRElementConstructor", 0, &JSHTMLBRElementConstructorTable };

bool JSHTMLBRElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBRElementConstructor, DOMObject>(exec, &JSHTMLBRElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBRElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLBRElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLBRElementPrototypeTable = 
{
    3, 1, JSHTMLBRElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLBRElementPrototype::info = { "HTMLBRElementPrototype", 0, &JSHTMLBRElementPrototypeTable };

JSObject* JSHTMLBRElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBRElementPrototype>(exec, "[[JSHTMLBRElement.prototype]]");
}

const ClassInfo JSHTMLBRElement::info = { "HTMLBRElement", &JSHTMLElement::info, &JSHTMLBRElementTable };

JSHTMLBRElement::JSHTMLBRElement(JSObject* prototype, HTMLBRElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLBRElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBRElement, Base>(exec, &JSHTMLBRElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBRElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ClearAttrNum: {
        HTMLBRElement* imp = static_cast<HTMLBRElement*>(impl());
        return jsString(imp->clear());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBRElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLBRElement, Base>(exec, propertyName, value, &JSHTMLBRElementTable, this);
}

void JSHTMLBRElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ClearAttrNum: {
        HTMLBRElement* imp = static_cast<HTMLBRElement*>(impl());
        imp->setClear(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLBRElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBRElementConstructor>(exec, "[[HTMLBRElement.constructor]]");
}


}
