/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLAreaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLAreaElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLAreaElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hash", { (intptr_t)JSHTMLAreaElement::HashAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "href", { (intptr_t)JSHTMLAreaElement::HrefAttrNum }, DontDelete, 0, &JSHTMLAreaElementTableEntries[33] },
    { "pathname", { (intptr_t)JSHTMLAreaElement::PathnameAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLAreaElementTableEntries[35] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "noHref", { (intptr_t)JSHTMLAreaElement::NoHrefAttrNum }, DontDelete, 0, 0 },
    { "hostname", { (intptr_t)JSHTMLAreaElement::HostnameAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "target", { (intptr_t)JSHTMLAreaElement::TargetAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "alt", { (intptr_t)JSHTMLAreaElement::AltAttrNum }, DontDelete, 0, &JSHTMLAreaElementTableEntries[34] },
    { 0, { 0 }, 0, 0, 0 },
    { "port", { (intptr_t)JSHTMLAreaElement::PortAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "shape", { (intptr_t)JSHTMLAreaElement::ShapeAttrNum }, DontDelete, 0, 0 },
    { "coords", { (intptr_t)JSHTMLAreaElement::CoordsAttrNum }, DontDelete, 0, &JSHTMLAreaElementTableEntries[32] },
    { "accessKey", { (intptr_t)JSHTMLAreaElement::AccessKeyAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "tabIndex", { (intptr_t)JSHTMLAreaElement::TabIndexAttrNum }, DontDelete, 0, 0 },
    { "host", { (intptr_t)JSHTMLAreaElement::HostAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "protocol", { (intptr_t)JSHTMLAreaElement::ProtocolAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLAreaElementTableEntries[36] },
    { "search", { (intptr_t)JSHTMLAreaElement::SearchAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLAreaElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLAreaElementTable = 
{
    3, 37, JSHTMLAreaElementTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSHTMLAreaElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementConstructorTable = 
{
    3, 1, JSHTMLAreaElementConstructorTableEntries, 0
};

class JSHTMLAreaElementConstructor : public DOMObject {
public:
    JSHTMLAreaElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLAreaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLAreaElementConstructor::info = { "HTMLAreaElementConstructor", 0, &JSHTMLAreaElementConstructorTable };

bool JSHTMLAreaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElementConstructor, DOMObject>(exec, &JSHTMLAreaElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLAreaElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLAreaElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementPrototypeTable = 
{
    3, 1, JSHTMLAreaElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLAreaElementPrototype::info = { "HTMLAreaElementPrototype", 0, &JSHTMLAreaElementPrototypeTable };

JSObject* JSHTMLAreaElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLAreaElementPrototype>(exec, "[[JSHTMLAreaElement.prototype]]");
}

const ClassInfo JSHTMLAreaElement::info = { "HTMLAreaElement", &JSHTMLElement::info, &JSHTMLAreaElementTable };

JSHTMLAreaElement::JSHTMLAreaElement(JSObject* prototype, HTMLAreaElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLAreaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElement, Base>(exec, &JSHTMLAreaElementTable, this, propertyName, slot);
}

JSValue* JSHTMLAreaElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->accessKey());
    }
    case AltAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->alt());
    }
    case CoordsAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->coords());
    }
    case HrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->href());
    }
    case NoHrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsBoolean(imp->noHref());
    }
    case ShapeAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->shape());
    }
    case TabIndexAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsNumber(imp->tabIndex());
    }
    case TargetAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->target());
    }
    case HashAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->hash());
    }
    case HostAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->host());
    }
    case HostnameAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->hostname());
    }
    case PathnameAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->pathname());
    }
    case PortAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->port());
    }
    case ProtocolAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->protocol());
    }
    case SearchAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        return jsString(imp->search());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLAreaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLAreaElement, Base>(exec, propertyName, value, &JSHTMLAreaElementTable, this);
}

void JSHTMLAreaElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CoordsAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setCoords(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setHref(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NoHrefAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setNoHref(value->toBoolean(exec));
        break;
    }
    case ShapeAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setShape(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TabIndexAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setTabIndex(value->toInt32(exec));
        break;
    }
    case TargetAttrNum: {
        HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(impl());
        imp->setTarget(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLAreaElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLAreaElementConstructor>(exec, "[[HTMLAreaElement.constructor]]");
}


}
