/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSEventException.h"

#include <wtf/GetPtr.h>

#include "EventException.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSEventExceptionTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "code", { (intptr_t)JSEventException::CodeAttrNum }, DontDelete|ReadOnly, 0, &JSEventExceptionTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "message", { (intptr_t)JSEventException::MessageAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "name", { (intptr_t)JSEventException::NameAttrNum }, DontDelete|ReadOnly, 0, &JSEventExceptionTableEntries[9] },
    { "constructor", { (intptr_t)JSEventException::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSEventExceptionTable = 
{
    3, 10, JSEventExceptionTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSEventExceptionConstructorTableEntries[] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", { (intptr_t)0 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSEventExceptionConstructorTable = 
{
    3, 2, JSEventExceptionConstructorTableEntries, 1
};

class JSEventExceptionConstructor : public DOMObject {
public:
    JSEventExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSEventExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSEventExceptionConstructor::info = { "EventExceptionConstructor", 0, &JSEventExceptionConstructorTable };

bool JSEventExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventExceptionConstructor, DOMObject>(exec, &JSEventExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSEventExceptionConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSEventExceptionPrototypeTableEntries[] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", { (intptr_t)0 }, DontDelete|ReadOnly, 0, &JSEventExceptionPrototypeTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "toString", { (intptr_t)jsEventExceptionPrototypeFunctionToString }, DontDelete|DontEnum|Function, 0, 0 }
};

static const HashTable JSEventExceptionPrototypeTable = 
{
    3, 5, JSEventExceptionPrototypeTableEntries, 3
};

const ClassInfo JSEventExceptionPrototype::info = { "EventExceptionPrototype", 0, &JSEventExceptionPrototypeTable };

JSObject* JSEventExceptionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSEventExceptionPrototype>(exec, "[[JSEventException.prototype]]");
}

bool JSEventExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSEventExceptionPrototype, JSObject>(exec, &JSEventExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSEventExceptionPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSEventException::info = { "EventException", 0, &JSEventExceptionTable };

JSEventException::JSEventException(JSObject* prototype, EventException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSEventException::~JSEventException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSEventException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventException, Base>(exec, &JSEventExceptionTable, this, propertyName, slot);
}

JSValue* JSEventException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        EventException* imp = static_cast<EventException*>(impl());
        return jsNumber(imp->code());
    }
    case NameAttrNum: {
        EventException* imp = static_cast<EventException*>(impl());
        return jsString(imp->name());
    }
    case MessageAttrNum: {
        EventException* imp = static_cast<EventException*>(impl());
        return jsString(imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSEventException::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSEventExceptionConstructor>(exec, "[[EventException.constructor]]");
}

JSValue* jsEventExceptionPrototypeFunctionToString(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSEventException::info))
        return throwError(exec, TypeError);
    JSEventException* castedThisObj = static_cast<JSEventException*>(thisObj);
    EventException* imp = static_cast<EventException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, EventException* obj)
{
    return cacheDOMObject<EventException, JSEventException, JSEventExceptionPrototype>(exec, obj);
}
EventException* toEventException(KJS::JSValue* val)
{
    return val->isObject(&JSEventException::info) ? static_cast<JSEventException*>(val)->impl() : 0;
}

}
