/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSEvent.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventTargetNode.h"
#include "JSEventTargetNode.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "returnValue", { (intptr_t)JSEvent::ReturnValueAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "timeStamp", { (intptr_t)JSEvent::TimeStampAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "eventPhase", { (intptr_t)JSEvent::EventPhaseAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "target", { (intptr_t)JSEvent::TargetAttrNum }, DontDelete|ReadOnly, 0, &JSEventTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "srcElement", { (intptr_t)JSEvent::SrcElementAttrNum }, DontDelete|ReadOnly, 0, &JSEventTableEntries[34] },
    { 0, { 0 }, 0, 0, 0 },
    { "type", { (intptr_t)JSEvent::TypeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "clipboardData", { (intptr_t)JSEvent::ClipboardDataAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "cancelable", { (intptr_t)JSEvent::CancelableAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "currentTarget", { (intptr_t)JSEvent::CurrentTargetAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "bubbles", { (intptr_t)JSEvent::BubblesAttrNum }, DontDelete|ReadOnly, 0, &JSEventTableEntries[33] },
    { "cancelBubble", { (intptr_t)JSEvent::CancelBubbleAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSEvent::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSEventTable = 
{
    3, 35, JSEventTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEOUT", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "FOCUS", { (intptr_t)4096 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CHANGE", { (intptr_t)32768 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEMOVE", { (intptr_t)16 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "AT_TARGET", { (intptr_t)2 }, DontDelete|ReadOnly, 0, &JSEventConstructorTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SELECT", { (intptr_t)16384 }, DontDelete|ReadOnly, 0, 0 },
    { "BLUR", { (intptr_t)8192 }, DontDelete|ReadOnly, 0, 0 },
    { "KEYUP", { (intptr_t)512 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEDOWN", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEDRAG", { (intptr_t)32 }, DontDelete|ReadOnly, 0, &JSEventConstructorTableEntries[67] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BUBBLING_PHASE", { (intptr_t)3 }, DontDelete|ReadOnly, 0, &JSEventConstructorTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEUP", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 },
    { "CAPTURING_PHASE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEOVER", { (intptr_t)4 }, DontDelete|ReadOnly, 0, 0 },
    { "CLICK", { (intptr_t)64 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DBLCLICK", { (intptr_t)128 }, DontDelete|ReadOnly, 0, 0 },
    { "KEYDOWN", { (intptr_t)256 }, DontDelete|ReadOnly, 0, &JSEventConstructorTableEntries[66] },
    { "KEYPRESS", { (intptr_t)1024 }, DontDelete|ReadOnly, 0, 0 },
    { "DRAGDROP", { (intptr_t)2048 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSEventConstructorTable = 
{
    3, 68, JSEventConstructorTableEntries, 63
};

class JSEventConstructor : public DOMObject {
public:
    JSEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSEventConstructor::info = { "EventConstructor", 0, &JSEventConstructorTable };

bool JSEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventConstructor, DOMObject>(exec, &JSEventConstructorTable, this, propertyName, slot);
}

JSValue* JSEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSEventPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEOUT", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "preventDefault", { (intptr_t)jsEventPrototypeFunctionPreventDefault }, DontDelete|Function, 0, 0 },
    { "FOCUS", { (intptr_t)4096 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CHANGE", { (intptr_t)32768 }, DontDelete|ReadOnly, 0, 0 },
    { "initEvent", { (intptr_t)jsEventPrototypeFunctionInitEvent }, DontDelete|Function, 3, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEMOVE", { (intptr_t)16 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "AT_TARGET", { (intptr_t)2 }, DontDelete|ReadOnly, 0, &JSEventPrototypeTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "stopPropagation", { (intptr_t)jsEventPrototypeFunctionStopPropagation }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SELECT", { (intptr_t)16384 }, DontDelete|ReadOnly, 0, 0 },
    { "BLUR", { (intptr_t)8192 }, DontDelete|ReadOnly, 0, 0 },
    { "KEYUP", { (intptr_t)512 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEDOWN", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEDRAG", { (intptr_t)32 }, DontDelete|ReadOnly, 0, &JSEventPrototypeTableEntries[67] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BUBBLING_PHASE", { (intptr_t)3 }, DontDelete|ReadOnly, 0, &JSEventPrototypeTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEUP", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 },
    { "CAPTURING_PHASE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "MOUSEOVER", { (intptr_t)4 }, DontDelete|ReadOnly, 0, 0 },
    { "CLICK", { (intptr_t)64 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DBLCLICK", { (intptr_t)128 }, DontDelete|ReadOnly, 0, 0 },
    { "KEYDOWN", { (intptr_t)256 }, DontDelete|ReadOnly, 0, &JSEventPrototypeTableEntries[66] },
    { "KEYPRESS", { (intptr_t)1024 }, DontDelete|ReadOnly, 0, 0 },
    { "DRAGDROP", { (intptr_t)2048 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSEventPrototypeTable = 
{
    3, 68, JSEventPrototypeTableEntries, 63
};

const ClassInfo JSEventPrototype::info = { "EventPrototype", 0, &JSEventPrototypeTable };

JSObject* JSEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSEventPrototype>(exec, "[[JSEvent.prototype]]");
}

bool JSEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSEventPrototype, JSObject>(exec, &JSEventPrototypeTable, this, propertyName, slot);
}

JSValue* JSEventPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSEvent::info = { "Event", 0, &JSEventTable };

JSEvent::JSEvent(JSObject* prototype, Event* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSEvent::~JSEvent()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEvent, Base>(exec, &JSEventTable, this, propertyName, slot);
}

JSValue* JSEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TypeAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsString(imp->type());
    }
    case TargetAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return toJS(exec, WTF::getPtr(imp->target()));
    }
    case CurrentTargetAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return toJS(exec, WTF::getPtr(imp->currentTarget()));
    }
    case EventPhaseAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsNumber(imp->eventPhase());
    }
    case BubblesAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->bubbles());
    }
    case CancelableAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->cancelable());
    }
    case TimeStampAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsNumber(imp->timeStamp());
    }
    case SrcElementAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return toJS(exec, WTF::getPtr(imp->srcElement()));
    }
    case ReturnValueAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->returnValue());
    }
    case CancelBubbleAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->cancelBubble());
    }
    case ClipboardDataAttrNum: {
        return clipboardData(exec);
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSEvent::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSEvent, Base>(exec, propertyName, value, &JSEventTable, this);
}

void JSEvent::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ReturnValueAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        imp->setReturnValue(value->toBoolean(exec));
        break;
    }
    case CancelBubbleAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        imp->setCancelBubble(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSEventConstructor>(exec, "[[Event.constructor]]");
}

JSValue* jsEventPrototypeFunctionStopPropagation(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSEvent::info))
        return throwError(exec, TypeError);
    JSEvent* castedThisObj = static_cast<JSEvent*>(thisObj);
    Event* imp = static_cast<Event*>(castedThisObj->impl());

    imp->stopPropagation();
    return jsUndefined();
}

JSValue* jsEventPrototypeFunctionPreventDefault(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSEvent::info))
        return throwError(exec, TypeError);
    JSEvent* castedThisObj = static_cast<JSEvent*>(thisObj);
    Event* imp = static_cast<Event*>(castedThisObj->impl());

    imp->preventDefault();
    return jsUndefined();
}

JSValue* jsEventPrototypeFunctionInitEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSEvent::info))
        return throwError(exec, TypeError);
    JSEvent* castedThisObj = static_cast<JSEvent*>(thisObj);
    Event* imp = static_cast<Event*>(castedThisObj->impl());
    String eventTypeArg = args[0]->toString(exec);
    bool canBubbleArg = args[1]->toBoolean(exec);
    bool cancelableArg = args[2]->toBoolean(exec);

    imp->initEvent(eventTypeArg, canBubbleArg, cancelableArg);
    return jsUndefined();
}

Event* toEvent(KJS::JSValue* val)
{
    return val->isObject(&JSEvent::info) ? static_cast<JSEvent*>(val)->impl() : 0;
}

}
