/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSEntityReference.h"

#include <wtf/GetPtr.h>

#include "EntityReference.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSEntityReferenceTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSEntityReference::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSEntityReferenceTable = 
{
    3, 2, JSEntityReferenceTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSEntityReferenceConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSEntityReferenceConstructorTable = 
{
    3, 1, JSEntityReferenceConstructorTableEntries, 0
};

class JSEntityReferenceConstructor : public DOMObject {
public:
    JSEntityReferenceConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSEntityReferencePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSEntityReferenceConstructor::info = { "EntityReferenceConstructor", 0, &JSEntityReferenceConstructorTable };

bool JSEntityReferenceConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityReferenceConstructor, DOMObject>(exec, &JSEntityReferenceConstructorTable, this, propertyName, slot);
}

JSValue* JSEntityReferenceConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSEntityReferencePrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSEntityReferencePrototypeTable = 
{
    3, 1, JSEntityReferencePrototypeTableEntries, 0
};

const ClassInfo JSEntityReferencePrototype::info = { "EntityReferencePrototype", 0, &JSEntityReferencePrototypeTable };

JSObject* JSEntityReferencePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSEntityReferencePrototype>(exec, "[[JSEntityReference.prototype]]");
}

const ClassInfo JSEntityReference::info = { "EntityReference", &JSNode::info, &JSEntityReferenceTable };

JSEntityReference::JSEntityReference(JSObject* prototype, EntityReference* impl)
    : JSNode(prototype, impl)
{
}

bool JSEntityReference::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityReference, Base>(exec, &JSEntityReferenceTable, this, propertyName, slot);
}

JSValue* JSEntityReference::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSEntityReference::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSEntityReferenceConstructor>(exec, "[[EntityReference.constructor]]");
}


}
