/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSElement.h"

#include <wtf/GetPtr.h>

#include "Attr.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "JSAttr.h"
#include "JSCSSStyleDeclaration.h"
#include "JSElement.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "clientTop", { (intptr_t)JSElement::ClientTopAttrNum }, DontDelete|ReadOnly, 0, &JSElementTableEntries[35] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "offsetParent", { (intptr_t)JSElement::OffsetParentAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "style", { (intptr_t)JSElement::StyleAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollLeft", { (intptr_t)JSElement::ScrollLeftAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "clientLeft", { (intptr_t)JSElement::ClientLeftAttrNum }, DontDelete|ReadOnly, 0, &JSElementTableEntries[34] },
    { 0, { 0 }, 0, 0, 0 },
    { "tagName", { (intptr_t)JSElement::TagNameAttrNum }, DontDelete|ReadOnly, 0, &JSElementTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { "offsetWidth", { (intptr_t)JSElement::OffsetWidthAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "clientWidth", { (intptr_t)JSElement::ClientWidthAttrNum }, DontDelete|ReadOnly, 0, &JSElementTableEntries[33] },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollWidth", { (intptr_t)JSElement::ScrollWidthAttrNum }, DontDelete|ReadOnly, 0, &JSElementTableEntries[36] },
    { "offsetTop", { (intptr_t)JSElement::OffsetTopAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "offsetLeft", { (intptr_t)JSElement::OffsetLeftAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "offsetHeight", { (intptr_t)JSElement::OffsetHeightAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "clientHeight", { (intptr_t)JSElement::ClientHeightAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "scrollTop", { (intptr_t)JSElement::ScrollTopAttrNum }, DontDelete, 0, 0 },
    { "scrollHeight", { (intptr_t)JSElement::ScrollHeightAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSElementTable = 
{
    3, 37, JSElementTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSElementConstructorTable = 
{
    3, 1, JSElementConstructorTableEntries, 0
};

class JSElementConstructor : public DOMObject {
public:
    JSElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSElementConstructor::info = { "ElementConstructor", 0, &JSElementConstructorTable };

bool JSElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSElementConstructor, DOMObject>(exec, &JSElementConstructorTable, this, propertyName, slot);
}

JSValue* JSElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "querySelector", { (intptr_t)jsElementPrototypeFunctionQuerySelector }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hasAttribute", { (intptr_t)jsElementPrototypeFunctionHasAttribute }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getAttributeNode", { (intptr_t)jsElementPrototypeFunctionGetAttributeNode }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getAttributeNS", { (intptr_t)jsElementPrototypeFunctionGetAttributeNS }, DontDelete|Function, 2, 0 },
    { "getElementsByTagNameNS", { (intptr_t)jsElementPrototypeFunctionGetElementsByTagNameNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getElementsByClassName", { (intptr_t)jsElementPrototypeFunctionGetElementsByClassName }, DontDelete|Function, 1, 0 },
    { "removeAttributeNS", { (intptr_t)jsElementPrototypeFunctionRemoveAttributeNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "querySelectorAll", { (intptr_t)jsElementPrototypeFunctionQuerySelectorAll }, DontDelete|Function, 1, 0 },
    { "contains", { (intptr_t)jsElementPrototypeFunctionContains }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollByPages", { (intptr_t)jsElementPrototypeFunctionScrollByPages }, DontDelete|Function, 1, 0 },
    { "setAttributeNode", { (intptr_t)jsElementPrototypeFunctionSetAttributeNode }, DontDelete|Function, 1, &JSElementPrototypeTableEntries[64] },
    { "setAttributeNS", { (intptr_t)jsElementPrototypeFunctionSetAttributeNS }, DontDelete|Function, 3, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hasAttributeNS", { (intptr_t)jsElementPrototypeFunctionHasAttributeNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "blur", { (intptr_t)jsElementPrototypeFunctionBlur }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "insertAdjacentElement", { (intptr_t)jsElementPrototypeFunctionInsertAdjacentElement }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollIntoViewIfNeeded", { (intptr_t)jsElementPrototypeFunctionScrollIntoViewIfNeeded }, DontDelete|Function, 1, 0 },
    { "setAttribute", { (intptr_t)jsElementPrototypeFunctionSetAttribute }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scrollByLines", { (intptr_t)jsElementPrototypeFunctionScrollByLines }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getElementsByTagName", { (intptr_t)jsElementPrototypeFunctionGetElementsByTagName }, DontDelete|Function, 1, 0 },
    { "removeAttribute", { (intptr_t)jsElementPrototypeFunctionRemoveAttribute }, DontDelete|Function, 1, &JSElementPrototypeTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { "setAttributeNodeNS", { (intptr_t)jsElementPrototypeFunctionSetAttributeNodeNS }, DontDelete|Function, 1, 0 },
    { "getAttribute", { (intptr_t)jsElementPrototypeFunctionGetAttribute }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "removeAttributeNode", { (intptr_t)jsElementPrototypeFunctionRemoveAttributeNode }, DontDelete|Function, 1, &JSElementPrototypeTableEntries[66] },
    { "getAttributeNodeNS", { (intptr_t)jsElementPrototypeFunctionGetAttributeNodeNS }, DontDelete|Function, 2, &JSElementPrototypeTableEntries[67] },
    { "focus", { (intptr_t)jsElementPrototypeFunctionFocus }, DontDelete|Function, 0, 0 },
    { "scrollIntoView", { (intptr_t)jsElementPrototypeFunctionScrollIntoView }, DontDelete|Function, 1, 0 }
};

static const HashTable JSElementPrototypeTable = 
{
    3, 68, JSElementPrototypeTableEntries, 63
};

const ClassInfo JSElementPrototype::info = { "ElementPrototype", 0, &JSElementPrototypeTable };

JSObject* JSElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSElementPrototype>(exec, "[[JSElement.prototype]]");
}

bool JSElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSElement::info = { "Element", &JSEventTargetNode::info, &JSElementTable };

JSElement::JSElement(JSObject* prototype, Element* impl)
    : JSEventTargetNode(prototype, impl)
{
}

bool JSElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSElement, Base>(exec, &JSElementTable, this, propertyName, slot);
}

JSValue* JSElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TagNameAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsStringOrNull(imp->tagName());
    }
    case StyleAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case OffsetLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->offsetLeft());
    }
    case OffsetTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->offsetTop());
    }
    case OffsetWidthAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->offsetWidth());
    }
    case OffsetHeightAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->offsetHeight());
    }
    case OffsetParentAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return toJS(exec, WTF::getPtr(imp->offsetParent()));
    }
    case ClientLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->clientLeft());
    }
    case ClientTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->clientTop());
    }
    case ClientWidthAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->clientWidth());
    }
    case ClientHeightAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->clientHeight());
    }
    case ScrollLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->scrollLeft());
    }
    case ScrollTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->scrollTop());
    }
    case ScrollWidthAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->scrollWidth());
    }
    case ScrollHeightAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        return jsNumber(imp->scrollHeight());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSElement, Base>(exec, propertyName, value, &JSElementTable, this);
}

void JSElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ScrollLeftAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        imp->setScrollLeft(value->toInt32(exec));
        break;
    }
    case ScrollTopAttrNum: {
        Element* imp = static_cast<Element*>(impl());
        imp->setScrollTop(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSElementConstructor>(exec, "[[Element.constructor]]");
}

JSValue* jsElementPrototypeFunctionGetAttribute(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = jsStringOrNull(imp->getAttribute(name));
    return result;
}

JSValue* jsElementPrototypeFunctionSetAttribute(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    return castedThisObj->setAttribute(exec, args);
}

JSValue* jsElementPrototypeFunctionRemoveAttribute(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String name = args[0]->toString(exec);

    imp->removeAttribute(name, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionGetAttributeNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getAttributeNode(name)));
    return result;
}

JSValue* jsElementPrototypeFunctionSetAttributeNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    return castedThisObj->setAttributeNode(exec, args);
}

JSValue* jsElementPrototypeFunctionRemoveAttributeNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Attr* oldAttr = toAttr(args[0]);
    if (!oldAttr) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return jsUndefined();
    }


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->removeAttributeNode(oldAttr, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsElementPrototypeFunctionGetElementsByTagName(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagName(name)));
    return result;
}

JSValue* jsElementPrototypeFunctionGetAttributeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = jsString(imp->getAttributeNS(namespaceURI, localName));
    return result;
}

JSValue* jsElementPrototypeFunctionSetAttributeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    return castedThisObj->setAttributeNS(exec, args);
}

JSValue* jsElementPrototypeFunctionRemoveAttributeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);

    imp->removeAttributeNS(namespaceURI, localName, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionGetElementsByTagNameNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
    return result;
}

JSValue* jsElementPrototypeFunctionGetAttributeNodeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getAttributeNodeNS(namespaceURI, localName)));
    return result;
}

JSValue* jsElementPrototypeFunctionSetAttributeNodeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    return castedThisObj->setAttributeNodeNS(exec, args);
}

JSValue* jsElementPrototypeFunctionHasAttribute(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->hasAttribute(name));
    return result;
}

JSValue* jsElementPrototypeFunctionHasAttributeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->hasAttributeNS(namespaceURI, localName));
    return result;
}

JSValue* jsElementPrototypeFunctionFocus(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    imp->focus();
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionBlur(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    imp->blur();
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionScrollIntoView(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    int argsCount = args.size();
    if (argsCount < 1) {
        imp->scrollIntoView();
        return jsUndefined();
    }

    bool alignWithTop = args[0]->toBoolean(exec);

    imp->scrollIntoView(alignWithTop);
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionInsertAdjacentElement(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String position = args[0]->toString(exec);
    Node* element = toNode(args[1]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->insertAdjacentElement(position, element, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsElementPrototypeFunctionContains(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    Element* element = toElement(args[0]);


    KJS::JSValue* result = jsBoolean(imp->contains(element));
    return result;
}

JSValue* jsElementPrototypeFunctionScrollIntoViewIfNeeded(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    int argsCount = args.size();
    if (argsCount < 1) {
        imp->scrollIntoViewIfNeeded();
        return jsUndefined();
    }

    bool centerIfNeeded = args[0]->toBoolean(exec);

    imp->scrollIntoViewIfNeeded(centerIfNeeded);
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionScrollByLines(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    int lines = args[0]->toInt32(exec);

    imp->scrollByLines(lines);
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionScrollByPages(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    int pages = args[0]->toInt32(exec);

    imp->scrollByPages(pages);
    return jsUndefined();
}

JSValue* jsElementPrototypeFunctionGetElementsByClassName(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByClassName(name)));
    return result;
}

JSValue* jsElementPrototypeFunctionQuerySelector(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String selectors = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsElementPrototypeFunctionQuerySelectorAll(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSElement::info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(thisObj);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String selectors = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

Element* toElement(KJS::JSValue* val)
{
    return val->isObject(&JSElement::info) ? static_cast<JSElement*>(val)->impl() : 0;
}

Element* JSElement::impl() const
{
    return static_cast<Element*>(Base::impl());
}

}
