/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDocument.h"

#include <wtf/GetPtr.h>

#include "Attr.h"
#include "CDATASection.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "EntityReference.h"
#include "Event.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMImplementation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "TreeWalker.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDocumentTableEntries[] =
{
    { "readyState", { (intptr_t)JSDocument::ReadyStateAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "anchors", { (intptr_t)JSDocument::AnchorsAttrNum }, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[69] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "applets", { (intptr_t)JSDocument::AppletsAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "characterSet", { (intptr_t)JSDocument::CharacterSetAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "documentElement", { (intptr_t)JSDocument::DocumentElementAttrNum }, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[66] },
    { "preferredStylesheetSet", { (intptr_t)JSDocument::PreferredStylesheetSetAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "xmlVersion", { (intptr_t)JSDocument::XMLVersionAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "title", { (intptr_t)JSDocument::TitleAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cookie", { (intptr_t)JSDocument::CookieAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "doctype", { (intptr_t)JSDocument::DoctypeAttrNum }, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[70] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "images", { (intptr_t)JSDocument::ImagesAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "body", { (intptr_t)JSDocument::BodyAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "inputEncoding", { (intptr_t)JSDocument::InputEncodingAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "xmlStandalone", { (intptr_t)JSDocument::XMLStandaloneAttrNum }, DontDelete, 0, &JSDocumentTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { "domain", { (intptr_t)JSDocument::DomainAttrNum }, DontDelete, 0, 0 },
    { "lastModified", { (intptr_t)JSDocument::LastModifiedAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "forms", { (intptr_t)JSDocument::FormsAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "location", { (intptr_t)JSDocument::LocationAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "charset", { (intptr_t)JSDocument::CharsetAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "xmlEncoding", { (intptr_t)JSDocument::XMLEncodingAttrNum }, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { "documentURI", { (intptr_t)JSDocument::DocumentURIAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "implementation", { (intptr_t)JSDocument::ImplementationAttrNum }, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[68] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "URL", { (intptr_t)JSDocument::URLAttrNum }, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[67] },
    { "defaultView", { (intptr_t)JSDocument::DefaultViewAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "styleSheets", { (intptr_t)JSDocument::StyleSheetsAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "referrer", { (intptr_t)JSDocument::ReferrerAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "links", { (intptr_t)JSDocument::LinksAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "defaultCharset", { (intptr_t)JSDocument::DefaultCharsetAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "selectedStylesheetSet", { (intptr_t)JSDocument::SelectedStylesheetSetAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSDocument::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSDocumentTable = 
{
    3, 71, JSDocumentTableEntries, 63
};

/* Hash table for constructor */

static const HashEntry JSDocumentConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSDocumentConstructorTable = 
{
    3, 1, JSDocumentConstructorTableEntries, 0
};

class JSDocumentConstructor : public DOMObject {
public:
    JSDocumentConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSDocumentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDocumentConstructor::info = { "DocumentConstructor", 0, &JSDocumentConstructorTable };

bool JSDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, slot);
}

JSValue* JSDocumentConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDocumentPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "evaluate", { (intptr_t)jsDocumentPrototypeFunctionEvaluate }, DontDelete|Function, 5, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createRange", { (intptr_t)jsDocumentPrototypeFunctionCreateRange }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createEvent", { (intptr_t)jsDocumentPrototypeFunctionCreateEvent }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createTextNode", { (intptr_t)jsDocumentPrototypeFunctionCreateTextNode }, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[134] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createAttributeNS", { (intptr_t)jsDocumentPrototypeFunctionCreateAttributeNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createElement", { (intptr_t)jsDocumentPrototypeFunctionCreateElement }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "importNode", { (intptr_t)jsDocumentPrototypeFunctionImportNode }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createComment", { (intptr_t)jsDocumentPrototypeFunctionCreateComment }, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[131] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createAttribute", { (intptr_t)jsDocumentPrototypeFunctionCreateAttribute }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "queryCommandState", { (intptr_t)jsDocumentPrototypeFunctionQueryCommandState }, DontDelete|Function, 1, 0 },
    { "getElementsByTagName", { (intptr_t)jsDocumentPrototypeFunctionGetElementsByTagName }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createNodeIterator", { (intptr_t)jsDocumentPrototypeFunctionCreateNodeIterator }, DontDelete|Function, 4, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "querySelector", { (intptr_t)jsDocumentPrototypeFunctionQuerySelector }, DontDelete|Function, 1, 0 },
    { "createEntityReference", { (intptr_t)jsDocumentPrototypeFunctionCreateEntityReference }, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[133] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getOverrideStyle", { (intptr_t)jsDocumentPrototypeFunctionGetOverrideStyle }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createNSResolver", { (intptr_t)jsDocumentPrototypeFunctionCreateNSResolver }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "adoptNode", { (intptr_t)jsDocumentPrototypeFunctionAdoptNode }, DontDelete|Function, 1, 0 },
    { "queryCommandEnabled", { (intptr_t)jsDocumentPrototypeFunctionQueryCommandEnabled }, DontDelete|Function, 1, 0 },
    { "getElementsByTagNameNS", { (intptr_t)jsDocumentPrototypeFunctionGetElementsByTagNameNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getElementsByClassName", { (intptr_t)jsDocumentPrototypeFunctionGetElementsByClassName }, DontDelete|Function, 1, 0 },
    { "createExpression", { (intptr_t)jsDocumentPrototypeFunctionCreateExpression }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createProcessingInstruction", { (intptr_t)jsDocumentPrototypeFunctionCreateProcessingInstruction }, DontDelete|Function, 2, 0 },
    { "createElementNS", { (intptr_t)jsDocumentPrototypeFunctionCreateElementNS }, DontDelete|Function, 2, 0 },
    { "createDocumentFragment", { (intptr_t)jsDocumentPrototypeFunctionCreateDocumentFragment }, DontDelete|Function, 0, &JSDocumentPrototypeTableEntries[130] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createCDATASection", { (intptr_t)jsDocumentPrototypeFunctionCreateCDATASection }, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[128] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "queryCommandIndeterm", { (intptr_t)jsDocumentPrototypeFunctionQueryCommandIndeterm }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "queryCommandValue", { (intptr_t)jsDocumentPrototypeFunctionQueryCommandValue }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getSelection", { (intptr_t)jsDocumentPrototypeFunctionGetSelection }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getElementById", { (intptr_t)jsDocumentPrototypeFunctionGetElementById }, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[129] },
    { "createTreeWalker", { (intptr_t)jsDocumentPrototypeFunctionCreateTreeWalker }, DontDelete|Function, 4, 0 },
    { "execCommand", { (intptr_t)jsDocumentPrototypeFunctionExecCommand }, DontDelete|Function, 3, 0 },
    { "queryCommandSupported", { (intptr_t)jsDocumentPrototypeFunctionQueryCommandSupported }, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[132] },
    { "getElementsByName", { (intptr_t)jsDocumentPrototypeFunctionGetElementsByName }, DontDelete|Function, 1, 0 },
    { "elementFromPoint", { (intptr_t)jsDocumentPrototypeFunctionElementFromPoint }, DontDelete|Function, 2, 0 },
    { "querySelectorAll", { (intptr_t)jsDocumentPrototypeFunctionQuerySelectorAll }, DontDelete|Function, 1, 0 }
};

static const HashTable JSDocumentPrototypeTable = 
{
    3, 135, JSDocumentPrototypeTableEntries, 127
};

const ClassInfo JSDocumentPrototype::info = { "DocumentPrototype", 0, &JSDocumentPrototypeTable };

JSObject* JSDocumentPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentPrototype>(exec, "[[JSDocument.prototype]]");
}

bool JSDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDocument::info = { "Document", &JSEventTargetNode::info, &JSDocumentTable };

JSDocument::JSDocument(JSObject* prototype, Document* impl)
    : JSEventTargetNode(prototype, impl)
{
}

JSDocument::~JSDocument()
{
    ScriptInterpreter::forgetDOMObject(static_cast<Document*>(impl()));
}

bool JSDocument::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocument, Base>(exec, &JSDocumentTable, this, propertyName, slot);
}

JSValue* JSDocument::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DoctypeAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->doctype()));
    }
    case ImplementationAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->implementation()));
    }
    case DocumentElementAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->documentElement()));
    }
    case InputEncodingAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->inputEncoding());
    }
    case XMLEncodingAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->xmlEncoding());
    }
    case XMLVersionAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->xmlVersion());
    }
    case XMLStandaloneAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsBoolean(imp->xmlStandalone());
    }
    case DocumentURIAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->documentURI());
    }
    case DefaultViewAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->defaultView()));
    }
    case StyleSheetsAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->styleSheets()));
    }
    case TitleAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsString(imp->title());
    }
    case ReferrerAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsString(imp->referrer());
    }
    case DomainAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsString(imp->domain());
    }
    case URLAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsString(imp->url());
    }
    case CookieAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsString(imp->cookie());
    }
    case BodyAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->body()));
    }
    case ImagesAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->images()));
    }
    case AppletsAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->applets()));
    }
    case LinksAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->links()));
    }
    case FormsAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->forms()));
    }
    case AnchorsAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return toJS(exec, WTF::getPtr(imp->anchors()));
    }
    case LastModifiedAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsString(imp->lastModified());
    }
    case LocationAttrNum: {
        return location(exec);
    }
    case CharsetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrUndefined(imp->charset());
    }
    case DefaultCharsetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrUndefined(imp->defaultCharset());
    }
    case ReadyStateAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrUndefined(imp->readyState());
    }
    case CharacterSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->characterSet());
    }
    case PreferredStylesheetSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->preferredStylesheetSet());
    }
    case SelectedStylesheetSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        return jsStringOrNull(imp->selectedStylesheetSet());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSDocument::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSDocument, Base>(exec, propertyName, value, &JSDocumentTable, this);
}

void JSDocument::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case XMLVersionAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        ExceptionCode ec = 0;
        imp->setXMLVersion(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case XMLStandaloneAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        ExceptionCode ec = 0;
        imp->setXMLStandalone(value->toBoolean(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case DocumentURIAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        imp->setDocumentURI(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TitleAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        imp->setTitle(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DomainAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        imp->setDomain(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CookieAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        imp->setCookie(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BodyAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        ExceptionCode ec = 0;
        imp->setBody(toHTMLElement(value), ec);
        setDOMException(exec, ec);
        break;
    }
    case LocationAttrNum: {
        setLocation(exec, value);
        break;
    }
    case CharsetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SelectedStylesheetSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());
        imp->setSelectedStylesheetSet(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSDocument::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentConstructor>(exec, "[[Document.constructor]]");
}

JSValue* jsDocumentPrototypeFunctionCreateElement(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String tagName = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createElement(tagName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateDocumentFragment(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createDocumentFragment()));
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateTextNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String data = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createTextNode(data)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateComment(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String data = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createComment(data)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateCDATASection(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String data = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createCDATASection(data, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateProcessingInstruction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String target = args[0]->toString(exec);
    String data = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createProcessingInstruction(target, data, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateAttribute(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createAttribute(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateEntityReference(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createEntityReference(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetElementsByTagName(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String tagname = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagName(tagname)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionImportNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* importedNode = toNode(args[0]);
    bool deep = args[1]->toBoolean(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->importNode(importedNode, deep, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateElementNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String qualifiedName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createElementNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateAttributeNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String qualifiedName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createAttributeNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetElementsByTagNameNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetElementById(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String elementId = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementById(elementId)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionAdoptNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* source = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->adoptNode(source, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String eventType = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createEvent(eventType, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateRange(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createRange()));
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateNodeIterator(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(args[0]);
    unsigned whatToShow = args[1]->toInt32(exec);
    NodeFilter* filter = toNodeFilter(args[2]);
    bool entityReferenceExpansion = args[3]->toBoolean(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createNodeIterator(root, whatToShow, filter, entityReferenceExpansion, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateTreeWalker(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(args[0]);
    unsigned whatToShow = args[1]->toInt32(exec);
    NodeFilter* filter = toNodeFilter(args[2]);
    bool entityReferenceExpansion = args[3]->toBoolean(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createTreeWalker(root, whatToShow, filter, entityReferenceExpansion, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetOverrideStyle(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    Element* element = toElement(args[0]);
    String pseudoElement = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getOverrideStyle(element, pseudoElement)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateExpression(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String expression = args[0]->toString(exec);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args[1]);
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args[1]);
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionCreateNSResolver(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    Node* nodeResolver = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createNSResolver(nodeResolver)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionEvaluate(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String expression = args[0]->toString(exec);
    Node* contextNode = toNode(args[1]);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args[2]);
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args[2]);
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }
    unsigned short type = args[3]->toInt32(exec);
    XPathResult* inResult = toXPathResult(args[4]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionExecCommand(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String command = args[0]->toString(exec);
    bool userInterface = args[1]->toBoolean(exec);
    String value = valueToStringWithUndefinedOrNullCheck(exec, args[2]);


    KJS::JSValue* result = jsBoolean(imp->execCommand(command, userInterface, value));
    return result;
}

JSValue* jsDocumentPrototypeFunctionQueryCommandEnabled(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String command = args[0]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->queryCommandEnabled(command));
    return result;
}

JSValue* jsDocumentPrototypeFunctionQueryCommandIndeterm(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String command = args[0]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->queryCommandIndeterm(command));
    return result;
}

JSValue* jsDocumentPrototypeFunctionQueryCommandState(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String command = args[0]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->queryCommandState(command));
    return result;
}

JSValue* jsDocumentPrototypeFunctionQueryCommandSupported(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String command = args[0]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->queryCommandSupported(command));
    return result;
}

JSValue* jsDocumentPrototypeFunctionQueryCommandValue(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String command = args[0]->toString(exec);


    KJS::JSValue* result = jsStringOrFalse(imp->queryCommandValue(command));
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetElementsByName(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String elementName = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByName(elementName)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionElementFromPoint(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    int x = args[0]->toInt32(exec);
    int y = args[1]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->elementFromPoint(x, y)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetSelection(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getSelection()));
    return result;
}

JSValue* jsDocumentPrototypeFunctionGetElementsByClassName(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    String tagname = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByClassName(tagname)));
    return result;
}

JSValue* jsDocumentPrototypeFunctionQuerySelector(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String selectors = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDocumentPrototypeFunctionQuerySelectorAll(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObj);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String selectors = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}


}
