/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDatabase.h"

#include <wtf/GetPtr.h>

#include "Database.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDatabaseTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "version", { (intptr_t)JSDatabase::VersionAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSDatabaseTable = 
{
    3, 2, JSDatabaseTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSDatabasePrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "transaction", { (intptr_t)jsDatabasePrototypeFunctionTransaction }, DontDelete|Function, 3, 0 },
    { "changeVersion", { (intptr_t)jsDatabasePrototypeFunctionChangeVersion }, DontDelete|Function, 5, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSDatabasePrototypeTable = 
{
    3, 4, JSDatabasePrototypeTableEntries, 3
};

const ClassInfo JSDatabasePrototype::info = { "DatabasePrototype", 0, &JSDatabasePrototypeTable };

JSObject* JSDatabasePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDatabasePrototype>(exec, "[[JSDatabase.prototype]]");
}

bool JSDatabasePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDatabasePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDatabase::info = { "Database", 0, &JSDatabaseTable };

JSDatabase::JSDatabase(JSObject* prototype, Database* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSDatabase::~JSDatabase()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSDatabase::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDatabase, Base>(exec, &JSDatabaseTable, this, propertyName, slot);
}

JSValue* JSDatabase::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case VersionAttrNum: {
        Database* imp = static_cast<Database*>(impl());
        return jsString(imp->version());
    }
    }
    return 0;
}

JSValue* jsDatabasePrototypeFunctionChangeVersion(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDatabase::info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(thisObj);
    return castedThisObj->changeVersion(exec, args);
}

JSValue* jsDatabasePrototypeFunctionTransaction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDatabase::info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(thisObj);
    return castedThisObj->transaction(exec, args);
}

KJS::JSValue* toJS(KJS::ExecState* exec, Database* obj)
{
    return cacheDOMObject<Database, JSDatabase, JSDatabasePrototype>(exec, obj);
}
Database* toDatabase(KJS::JSValue* val)
{
    return val->isObject(&JSDatabase::info) ? static_cast<JSDatabase*>(val)->impl() : 0;
}

}
