/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMParser.h"

#include <wtf/GetPtr.h>

#include "DOMParser.h"
#include "Document.h"
#include "JSDocument.h"
#include "NodeFilter.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDOMParserTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSDOMParser::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSDOMParserTable = 
{
    3, 2, JSDOMParserTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSDOMParserConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSDOMParserConstructorTable = 
{
    3, 1, JSDOMParserConstructorTableEntries, 0
};

class JSDOMParserConstructor : public DOMObject {
public:
    JSDOMParserConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSDOMParserPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
    virtual bool implementsConstruct() const { return true; }
    virtual JSObject* construct(ExecState* exec, const List& args) { return static_cast<JSObject*>(toJS(exec, DOMParser::create())); }
};

const ClassInfo JSDOMParserConstructor::info = { "DOMParserConstructor", 0, &JSDOMParserConstructorTable };

bool JSDOMParserConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMParserConstructor, DOMObject>(exec, &JSDOMParserConstructorTable, this, propertyName, slot);
}

JSValue* JSDOMParserConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDOMParserPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "parseFromString", { (intptr_t)jsDOMParserPrototypeFunctionParseFromString }, DontDelete|Function, 2, 0 }
};

static const HashTable JSDOMParserPrototypeTable = 
{
    3, 2, JSDOMParserPrototypeTableEntries, 1
};

const ClassInfo JSDOMParserPrototype::info = { "DOMParserPrototype", 0, &JSDOMParserPrototypeTable };

JSObject* JSDOMParserPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMParserPrototype>(exec, "[[JSDOMParser.prototype]]");
}

bool JSDOMParserPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMParserPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMParser::info = { "DOMParser", 0, &JSDOMParserTable };

JSDOMParser::JSDOMParser(JSObject* prototype, DOMParser* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSDOMParser::~JSDOMParser()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSDOMParser::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMParser, Base>(exec, &JSDOMParserTable, this, propertyName, slot);
}

JSValue* JSDOMParser::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDOMParser::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMParserConstructor>(exec, "[[DOMParser.constructor]]");
}

JSValue* jsDOMParserPrototypeFunctionParseFromString(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMParser::info))
        return throwError(exec, TypeError);
    JSDOMParser* castedThisObj = static_cast<JSDOMParser*>(thisObj);
    DOMParser* imp = static_cast<DOMParser*>(castedThisObj->impl());
    String str = args[0]->toString(exec);
    String contentType = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->parseFromString(str, contentType)));
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, DOMParser* obj)
{
    return cacheDOMObject<DOMParser, JSDOMParser, JSDOMParserPrototype>(exec, obj);
}
DOMParser* toDOMParser(KJS::JSValue* val)
{
    return val->isObject(&JSDOMParser::info) ? static_cast<JSDOMParser*>(val)->impl() : 0;
}

}
