/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMImplementation.h"

#include <wtf/GetPtr.h>

#include "CSSStyleSheet.h"
#include "DOMImplementation.h"
#include "Document.h"
#include "DocumentType.h"
#include "HTMLDocument.h"
#include "JSCSSStyleSheet.h"
#include "JSDocument.h"
#include "JSDocumentType.h"
#include "JSHTMLDocument.h"
#include "NodeFilter.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDOMImplementationTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSDOMImplementation::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSDOMImplementationTable = 
{
    3, 2, JSDOMImplementationTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSDOMImplementationConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSDOMImplementationConstructorTable = 
{
    3, 1, JSDOMImplementationConstructorTableEntries, 0
};

class JSDOMImplementationConstructor : public DOMObject {
public:
    JSDOMImplementationConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSDOMImplementationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDOMImplementationConstructor::info = { "DOMImplementationConstructor", 0, &JSDOMImplementationConstructorTable };

bool JSDOMImplementationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMImplementationConstructor, DOMObject>(exec, &JSDOMImplementationConstructorTable, this, propertyName, slot);
}

JSValue* JSDOMImplementationConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDOMImplementationPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createDocument", { (intptr_t)jsDOMImplementationPrototypeFunctionCreateDocument }, DontDelete|Function, 3, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createDocumentType", { (intptr_t)jsDOMImplementationPrototypeFunctionCreateDocumentType }, DontDelete|Function, 3, &JSDOMImplementationPrototypeTableEntries[16] },
    { "hasFeature", { (intptr_t)jsDOMImplementationPrototypeFunctionHasFeature }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "createHTMLDocument", { (intptr_t)jsDOMImplementationPrototypeFunctionCreateHTMLDocument }, DontDelete|Function, 1, 0 },
    { "createCSSStyleSheet", { (intptr_t)jsDOMImplementationPrototypeFunctionCreateCSSStyleSheet }, DontDelete|Function, 2, 0 }
};

static const HashTable JSDOMImplementationPrototypeTable = 
{
    3, 17, JSDOMImplementationPrototypeTableEntries, 15
};

const ClassInfo JSDOMImplementationPrototype::info = { "DOMImplementationPrototype", 0, &JSDOMImplementationPrototypeTable };

JSObject* JSDOMImplementationPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMImplementationPrototype>(exec, "[[JSDOMImplementation.prototype]]");
}

bool JSDOMImplementationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMImplementationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMImplementation::info = { "DOMImplementation", 0, &JSDOMImplementationTable };

JSDOMImplementation::JSDOMImplementation(JSObject* prototype, DOMImplementation* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSDOMImplementation::~JSDOMImplementation()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSDOMImplementation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMImplementation, Base>(exec, &JSDOMImplementationTable, this, propertyName, slot);
}

JSValue* JSDOMImplementation::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDOMImplementation::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMImplementationConstructor>(exec, "[[DOMImplementation.constructor]]");
}

JSValue* jsDOMImplementationPrototypeFunctionHasFeature(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMImplementation::info))
        return throwError(exec, TypeError);
    JSDOMImplementation* castedThisObj = static_cast<JSDOMImplementation*>(thisObj);
    DOMImplementation* imp = static_cast<DOMImplementation*>(castedThisObj->impl());
    String feature = args[0]->toString(exec);
    String version = valueToStringWithNullCheck(exec, args[1]);


    KJS::JSValue* result = jsBoolean(imp->hasFeature(feature, version));
    return result;
}

JSValue* jsDOMImplementationPrototypeFunctionCreateDocumentType(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMImplementation::info))
        return throwError(exec, TypeError);
    JSDOMImplementation* castedThisObj = static_cast<JSDOMImplementation*>(thisObj);
    DOMImplementation* imp = static_cast<DOMImplementation*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String qualifiedName = args[0]->toString(exec);
    String publicId = args[1]->toString(exec);
    String systemId = args[2]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createDocumentType(qualifiedName, publicId, systemId, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDOMImplementationPrototypeFunctionCreateDocument(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMImplementation::info))
        return throwError(exec, TypeError);
    JSDOMImplementation* castedThisObj = static_cast<JSDOMImplementation*>(thisObj);
    DOMImplementation* imp = static_cast<DOMImplementation*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String qualifiedName = valueToStringWithNullCheck(exec, args[1]);
    DocumentType* doctype = toDocumentType(args[2]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createDocument(namespaceURI, qualifiedName, doctype, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDOMImplementationPrototypeFunctionCreateCSSStyleSheet(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMImplementation::info))
        return throwError(exec, TypeError);
    JSDOMImplementation* castedThisObj = static_cast<JSDOMImplementation*>(thisObj);
    DOMImplementation* imp = static_cast<DOMImplementation*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String title = args[0]->toString(exec);
    String media = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createCSSStyleSheet(title, media, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDOMImplementationPrototypeFunctionCreateHTMLDocument(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMImplementation::info))
        return throwError(exec, TypeError);
    JSDOMImplementation* castedThisObj = static_cast<JSDOMImplementation*>(thisObj);
    DOMImplementation* imp = static_cast<DOMImplementation*>(castedThisObj->impl());
    String title = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createHTMLDocument(title)));
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, DOMImplementation* obj)
{
    return cacheDOMObject<DOMImplementation, JSDOMImplementation, JSDOMImplementationPrototype>(exec, obj);
}
DOMImplementation* toDOMImplementation(KJS::JSValue* val)
{
    return val->isObject(&JSDOMImplementation::info) ? static_cast<JSDOMImplementation*>(val)->impl() : 0;
}

}
