/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMCoreException.h"

#include <wtf/GetPtr.h>

#include "DOMCoreException.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDOMCoreExceptionTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "code", { (intptr_t)JSDOMCoreException::CodeAttrNum }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "message", { (intptr_t)JSDOMCoreException::MessageAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "name", { (intptr_t)JSDOMCoreException::NameAttrNum }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionTableEntries[9] },
    { "constructor", { (intptr_t)JSDOMCoreException::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSDOMCoreExceptionTable = 
{
    3, 10, JSDOMCoreExceptionTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSDOMCoreExceptionConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INUSE_ATTRIBUTE_ERR", { (intptr_t)10 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "WRONG_DOCUMENT_ERR", { (intptr_t)4 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "HIERARCHY_REQUEST_ERR", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NO_MODIFICATION_ALLOWED_ERR", { (intptr_t)7 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "VALIDATION_ERR", { (intptr_t)16 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NOT_FOUND_ERR", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NOT_SUPPORTED_ERR", { (intptr_t)9 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DOMSTRING_SIZE_ERR", { (intptr_t)2 }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionConstructorTableEntries[66] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "TYPE_MISMATCH_ERR", { (intptr_t)17 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NO_DATA_ALLOWED_ERR", { (intptr_t)6 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SYNTAX_ERR", { (intptr_t)12 }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionConstructorTableEntries[65] },
    { "INDEX_SIZE_ERR", { (intptr_t)1 }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionConstructorTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_MODIFICATION_ERR", { (intptr_t)13 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_CHARACTER_ERR", { (intptr_t)5 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_STATE_ERR", { (intptr_t)11 }, DontDelete|ReadOnly, 0, 0 },
    { "NAMESPACE_ERR", { (intptr_t)14 }, DontDelete|ReadOnly, 0, 0 },
    { "INVALID_ACCESS_ERR", { (intptr_t)15 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSDOMCoreExceptionConstructorTable = 
{
    3, 67, JSDOMCoreExceptionConstructorTableEntries, 63
};

class JSDOMCoreExceptionConstructor : public DOMObject {
public:
    JSDOMCoreExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSDOMCoreExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDOMCoreExceptionConstructor::info = { "DOMExceptionConstructor", 0, &JSDOMCoreExceptionConstructorTable };

bool JSDOMCoreExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreExceptionConstructor, DOMObject>(exec, &JSDOMCoreExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSDOMCoreExceptionConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDOMCoreExceptionPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INUSE_ATTRIBUTE_ERR", { (intptr_t)10 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "WRONG_DOCUMENT_ERR", { (intptr_t)4 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "HIERARCHY_REQUEST_ERR", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "toString", { (intptr_t)jsDOMCoreExceptionPrototypeFunctionToString }, DontDelete|DontEnum|Function, 0, 0 },
    { "NO_MODIFICATION_ALLOWED_ERR", { (intptr_t)7 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "VALIDATION_ERR", { (intptr_t)16 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NOT_FOUND_ERR", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NOT_SUPPORTED_ERR", { (intptr_t)9 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DOMSTRING_SIZE_ERR", { (intptr_t)2 }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionPrototypeTableEntries[66] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "TYPE_MISMATCH_ERR", { (intptr_t)17 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NO_DATA_ALLOWED_ERR", { (intptr_t)6 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SYNTAX_ERR", { (intptr_t)12 }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionPrototypeTableEntries[65] },
    { "INDEX_SIZE_ERR", { (intptr_t)1 }, DontDelete|ReadOnly, 0, &JSDOMCoreExceptionPrototypeTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_MODIFICATION_ERR", { (intptr_t)13 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_CHARACTER_ERR", { (intptr_t)5 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_STATE_ERR", { (intptr_t)11 }, DontDelete|ReadOnly, 0, 0 },
    { "NAMESPACE_ERR", { (intptr_t)14 }, DontDelete|ReadOnly, 0, 0 },
    { "INVALID_ACCESS_ERR", { (intptr_t)15 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSDOMCoreExceptionPrototypeTable = 
{
    3, 67, JSDOMCoreExceptionPrototypeTableEntries, 63
};

const ClassInfo JSDOMCoreExceptionPrototype::info = { "DOMExceptionPrototype", 0, &JSDOMCoreExceptionPrototypeTable };

JSObject* JSDOMCoreExceptionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMCoreExceptionPrototype>(exec, "[[JSDOMCoreException.prototype]]");
}

bool JSDOMCoreExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSDOMCoreExceptionPrototype, JSObject>(exec, &JSDOMCoreExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSDOMCoreExceptionPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSDOMCoreException::info = { "DOMException", 0, &JSDOMCoreExceptionTable };

JSDOMCoreException::JSDOMCoreException(JSObject* prototype, DOMCoreException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSDOMCoreException::~JSDOMCoreException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSDOMCoreException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreException, Base>(exec, &JSDOMCoreExceptionTable, this, propertyName, slot);
}

JSValue* JSDOMCoreException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        DOMCoreException* imp = static_cast<DOMCoreException*>(impl());
        return jsNumber(imp->code());
    }
    case NameAttrNum: {
        DOMCoreException* imp = static_cast<DOMCoreException*>(impl());
        return jsString(imp->name());
    }
    case MessageAttrNum: {
        DOMCoreException* imp = static_cast<DOMCoreException*>(impl());
        return jsString(imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDOMCoreException::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMCoreExceptionConstructor>(exec, "[[DOMCoreException.constructor]]");
}

JSValue* jsDOMCoreExceptionPrototypeFunctionToString(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMCoreException::info))
        return throwError(exec, TypeError);
    JSDOMCoreException* castedThisObj = static_cast<JSDOMCoreException*>(thisObj);
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, DOMCoreException* obj)
{
    return cacheDOMObject<DOMCoreException, JSDOMCoreException, JSDOMCoreExceptionPrototype>(exec, obj);
}
DOMCoreException* toDOMCoreException(KJS::JSValue* val)
{
    return val->isObject(&JSDOMCoreException::info) ? static_cast<JSDOMCoreException*>(val)->impl() : 0;
}

}
