/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCounter.h"

#include <wtf/GetPtr.h>

#include "Counter.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCounterTableEntries[] =
{
    { "identifier", { (intptr_t)JSCounter::IdentifierAttrNum }, DontDelete|ReadOnly, 0, &JSCounterTableEntries[8] },
    { "constructor", { (intptr_t)JSCounter::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "separator", { (intptr_t)JSCounter::SeparatorAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "listStyle", { (intptr_t)JSCounter::ListStyleAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCounterTable = 
{
    3, 9, JSCounterTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSCounterConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCounterConstructorTable = 
{
    3, 1, JSCounterConstructorTableEntries, 0
};

class JSCounterConstructor : public DOMObject {
public:
    JSCounterConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCounterPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCounterConstructor::info = { "CounterConstructor", 0, &JSCounterConstructorTable };

bool JSCounterConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCounterConstructor, DOMObject>(exec, &JSCounterConstructorTable, this, propertyName, slot);
}

JSValue* JSCounterConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCounterPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCounterPrototypeTable = 
{
    3, 1, JSCounterPrototypeTableEntries, 0
};

const ClassInfo JSCounterPrototype::info = { "CounterPrototype", 0, &JSCounterPrototypeTable };

JSObject* JSCounterPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCounterPrototype>(exec, "[[JSCounter.prototype]]");
}

const ClassInfo JSCounter::info = { "Counter", 0, &JSCounterTable };

JSCounter::JSCounter(JSObject* prototype, Counter* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCounter::~JSCounter()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCounter::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCounter, Base>(exec, &JSCounterTable, this, propertyName, slot);
}

JSValue* JSCounter::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case IdentifierAttrNum: {
        Counter* imp = static_cast<Counter*>(impl());
        return jsString(imp->identifier());
    }
    case ListStyleAttrNum: {
        Counter* imp = static_cast<Counter*>(impl());
        return jsString(imp->listStyle());
    }
    case SeparatorAttrNum: {
        Counter* imp = static_cast<Counter*>(impl());
        return jsString(imp->separator());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCounter::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCounterConstructor>(exec, "[[Counter.constructor]]");
}

KJS::JSValue* toJS(KJS::ExecState* exec, Counter* obj)
{
    return cacheDOMObject<Counter, JSCounter, JSCounterPrototype>(exec, obj);
}
Counter* toCounter(KJS::JSValue* val)
{
    return val->isObject(&JSCounter::info) ? static_cast<JSCounter*>(val)->impl() : 0;
}

}
