/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSConsole.h"

#include <wtf/GetPtr.h>

#include "Console.h"

using namespace KJS;

namespace WebCore {

/* Hash table for prototype */

static const HashEntry JSConsolePrototypeTableEntries[] =
{
    { "warn", { (intptr_t)jsConsolePrototypeFunctionWarn }, DontDelete|Function, 1, 0 },
    { "error", { (intptr_t)jsConsolePrototypeFunctionError }, DontDelete|Function, 1, &JSConsolePrototypeTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "log", { (intptr_t)jsConsolePrototypeFunctionLog }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "info", { (intptr_t)jsConsolePrototypeFunctionInfo }, DontDelete|Function, 1, 0 }
};

static const HashTable JSConsolePrototypeTable = 
{
    3, 9, JSConsolePrototypeTableEntries, 7
};

const ClassInfo JSConsolePrototype::info = { "ConsolePrototype", 0, &JSConsolePrototypeTable };

JSObject* JSConsolePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSConsolePrototype>(exec, "[[JSConsole.prototype]]");
}

bool JSConsolePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSConsolePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSConsole::info = { "Console", 0, 0 };

JSConsole::JSConsole(JSObject* prototype, Console* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSConsole::~JSConsole()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

JSValue* jsConsolePrototypeFunctionError(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSConsole::info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisObj);
    Console* imp = static_cast<Console*>(castedThisObj->impl());
    String message = args[0]->toString(exec);

    imp->error(message);
    return jsUndefined();
}

JSValue* jsConsolePrototypeFunctionInfo(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSConsole::info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisObj);
    Console* imp = static_cast<Console*>(castedThisObj->impl());
    String message = args[0]->toString(exec);

    imp->info(message);
    return jsUndefined();
}

JSValue* jsConsolePrototypeFunctionLog(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSConsole::info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisObj);
    Console* imp = static_cast<Console*>(castedThisObj->impl());
    String message = args[0]->toString(exec);

    imp->log(message);
    return jsUndefined();
}

JSValue* jsConsolePrototypeFunctionWarn(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSConsole::info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisObj);
    Console* imp = static_cast<Console*>(castedThisObj->impl());
    String message = args[0]->toString(exec);

    imp->warn(message);
    return jsUndefined();
}

KJS::JSValue* toJS(KJS::ExecState* exec, Console* obj)
{
    return cacheDOMObject<Console, JSConsole, JSConsolePrototype>(exec, obj);
}
Console* toConsole(KJS::JSValue* val)
{
    return val->isObject(&JSConsole::info) ? static_cast<JSConsole*>(val)->impl() : 0;
}

}
