/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSComment.h"

#include <wtf/GetPtr.h>

#include "Comment.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCommentTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSComment::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSCommentTable = 
{
    3, 2, JSCommentTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSCommentConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCommentConstructorTable = 
{
    3, 1, JSCommentConstructorTableEntries, 0
};

class JSCommentConstructor : public DOMObject {
public:
    JSCommentConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCommentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCommentConstructor::info = { "CommentConstructor", 0, &JSCommentConstructorTable };

bool JSCommentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCommentConstructor, DOMObject>(exec, &JSCommentConstructorTable, this, propertyName, slot);
}

JSValue* JSCommentConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCommentPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCommentPrototypeTable = 
{
    3, 1, JSCommentPrototypeTableEntries, 0
};

const ClassInfo JSCommentPrototype::info = { "CommentPrototype", 0, &JSCommentPrototypeTable };

JSObject* JSCommentPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCommentPrototype>(exec, "[[JSComment.prototype]]");
}

const ClassInfo JSComment::info = { "Comment", &JSCharacterData::info, &JSCommentTable };

JSComment::JSComment(JSObject* prototype, Comment* impl)
    : JSCharacterData(prototype, impl)
{
}

bool JSComment::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSComment, Base>(exec, &JSCommentTable, this, propertyName, slot);
}

JSValue* JSComment::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSComment::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCommentConstructor>(exec, "[[Comment.constructor]]");
}


}
