/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSClipboard.h"

#include <wtf/GetPtr.h>

#include "Clipboard.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSClipboardTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "effectAllowed", { (intptr_t)JSClipboard::EffectAllowedAttrNum }, DontDelete, 0, &JSClipboardTableEntries[9] },
    { "dropEffect", { (intptr_t)JSClipboard::DropEffectAttrNum }, DontDelete, 0, &JSClipboardTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "types", { (intptr_t)JSClipboard::TypesAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSClipboard::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSClipboardTable = 
{
    3, 10, JSClipboardTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSClipboardConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSClipboardConstructorTable = 
{
    3, 1, JSClipboardConstructorTableEntries, 0
};

class JSClipboardConstructor : public DOMObject {
public:
    JSClipboardConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSClipboardPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSClipboardConstructor::info = { "ClipboardConstructor", 0, &JSClipboardConstructorTable };

bool JSClipboardConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboardConstructor, DOMObject>(exec, &JSClipboardConstructorTable, this, propertyName, slot);
}

JSValue* JSClipboardConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSClipboardPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "setData", { (intptr_t)jsClipboardPrototypeFunctionSetData }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "setDragImage", { (intptr_t)jsClipboardPrototypeFunctionSetDragImage }, DontDelete|Function, 3, 0 },
    { "clearData", { (intptr_t)jsClipboardPrototypeFunctionClearData }, DontDelete|Function, 1, 0 },
    { "getData", { (intptr_t)jsClipboardPrototypeFunctionGetData }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSClipboardPrototypeTable = 
{
    3, 8, JSClipboardPrototypeTableEntries, 7
};

const ClassInfo JSClipboardPrototype::info = { "ClipboardPrototype", 0, &JSClipboardPrototypeTable };

JSObject* JSClipboardPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSClipboardPrototype>(exec, "[[JSClipboard.prototype]]");
}

bool JSClipboardPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSClipboardPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSClipboard::info = { "Clipboard", 0, &JSClipboardTable };

JSClipboard::JSClipboard(JSObject* prototype, Clipboard* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSClipboard::~JSClipboard()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSClipboard::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboard, Base>(exec, &JSClipboardTable, this, propertyName, slot);
}

JSValue* JSClipboard::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DropEffectAttrNum: {
        Clipboard* imp = static_cast<Clipboard*>(impl());
        return jsStringOrUndefined(imp->dropEffect());
    }
    case EffectAllowedAttrNum: {
        Clipboard* imp = static_cast<Clipboard*>(impl());
        return jsStringOrUndefined(imp->effectAllowed());
    }
    case TypesAttrNum: {
        return types(exec);
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSClipboard::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSClipboard, Base>(exec, propertyName, value, &JSClipboardTable, this);
}

void JSClipboard::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case DropEffectAttrNum: {
        Clipboard* imp = static_cast<Clipboard*>(impl());
        imp->setDropEffect(value->toString(exec));
        break;
    }
    case EffectAllowedAttrNum: {
        Clipboard* imp = static_cast<Clipboard*>(impl());
        imp->setEffectAllowed(value->toString(exec));
        break;
    }
    }
}

JSValue* JSClipboard::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSClipboardConstructor>(exec, "[[Clipboard.constructor]]");
}

JSValue* jsClipboardPrototypeFunctionClearData(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSClipboard::info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(thisObj);
    return castedThisObj->clearData(exec, args);
}

JSValue* jsClipboardPrototypeFunctionGetData(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSClipboard::info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(thisObj);
    return castedThisObj->getData(exec, args);
}

JSValue* jsClipboardPrototypeFunctionSetData(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSClipboard::info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(thisObj);
    return castedThisObj->setData(exec, args);
}

JSValue* jsClipboardPrototypeFunctionSetDragImage(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSClipboard::info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(thisObj);
    return castedThisObj->setDragImage(exec, args);
}

KJS::JSValue* toJS(KJS::ExecState* exec, Clipboard* obj)
{
    return cacheDOMObject<Clipboard, JSClipboard, JSClipboardPrototype>(exec, obj);
}
Clipboard* toClipboard(KJS::JSValue* val)
{
    return val->isObject(&JSClipboard::info) ? static_cast<JSClipboard*>(val)->impl() : 0;
}

}
