/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSValue.h"

#include <wtf/GetPtr.h>

#include "CSSValue.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSValueTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSCSSValue::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cssText", { (intptr_t)JSCSSValue::CssTextAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cssValueType", { (intptr_t)JSCSSValue::CssValueTypeAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSValueTable = 
{
    3, 8, JSCSSValueTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSCSSValueConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CSS_CUSTOM", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { "CSS_PRIMITIVE_VALUE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CSS_INHERIT", { (intptr_t)0 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CSS_VALUE_LIST", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSValueConstructorTable = 
{
    3, 8, JSCSSValueConstructorTableEntries, 7
};

class JSCSSValueConstructor : public DOMObject {
public:
    JSCSSValueConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSValuePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSValueConstructor::info = { "CSSValueConstructor", 0, &JSCSSValueConstructorTable };

bool JSCSSValueConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSValueConstructor, DOMObject>(exec, &JSCSSValueConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSValueConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSValuePrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CSS_CUSTOM", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { "CSS_PRIMITIVE_VALUE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CSS_INHERIT", { (intptr_t)0 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "CSS_VALUE_LIST", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSValuePrototypeTable = 
{
    3, 8, JSCSSValuePrototypeTableEntries, 7
};

const ClassInfo JSCSSValuePrototype::info = { "CSSValuePrototype", 0, &JSCSSValuePrototypeTable };

JSObject* JSCSSValuePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSValuePrototype>(exec, "[[JSCSSValue.prototype]]");
}

bool JSCSSValuePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSValuePrototype, JSObject>(exec, &JSCSSValuePrototypeTable, this, propertyName, slot);
}

JSValue* JSCSSValuePrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSCSSValue::info = { "CSSValue", 0, &JSCSSValueTable };

JSCSSValue::JSCSSValue(JSObject* prototype, CSSValue* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCSSValue::~JSCSSValue()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCSSValue::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSValue, Base>(exec, &JSCSSValueTable, this, propertyName, slot);
}

JSValue* JSCSSValue::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CssTextAttrNum: {
        CSSValue* imp = static_cast<CSSValue*>(impl());
        return jsStringOrNull(imp->cssText());
    }
    case CssValueTypeAttrNum: {
        CSSValue* imp = static_cast<CSSValue*>(impl());
        return jsNumber(imp->cssValueType());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSValue::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSCSSValue, Base>(exec, propertyName, value, &JSCSSValueTable, this);
}

void JSCSSValue::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CssTextAttrNum: {
        CSSValue* imp = static_cast<CSSValue*>(impl());
        ExceptionCode ec = 0;
        imp->setCssText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSCSSValue::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSValueConstructor>(exec, "[[CSSValue.constructor]]");
}

CSSValue* toCSSValue(KJS::JSValue* val)
{
    return val->isObject(&JSCSSValue::info) ? static_cast<JSCSSValue*>(val)->impl() : 0;
}

}
