/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleSheet.h"

#include <wtf/GetPtr.h>

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSStyleSheetTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "ownerRule", { (intptr_t)JSCSSStyleSheet::OwnerRuleAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "rules", { (intptr_t)JSCSSStyleSheet::RulesAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cssRules", { (intptr_t)JSCSSStyleSheet::CssRulesAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSStyleSheetTable = 
{
    3, 8, JSCSSStyleSheetTableEntries, 7
};

/* Hash table for prototype */

static const HashEntry JSCSSStyleSheetPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "addRule", { (intptr_t)jsCSSStyleSheetPrototypeFunctionAddRule }, DontDelete|Function, 3, 0 },
    { "insertRule", { (intptr_t)jsCSSStyleSheetPrototypeFunctionInsertRule }, DontDelete|Function, 2, 0 },
    { "removeRule", { (intptr_t)jsCSSStyleSheetPrototypeFunctionRemoveRule }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "deleteRule", { (intptr_t)jsCSSStyleSheetPrototypeFunctionDeleteRule }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetPrototypeTable = 
{
    3, 8, JSCSSStyleSheetPrototypeTableEntries, 7
};

const ClassInfo JSCSSStyleSheetPrototype::info = { "CSSStyleSheetPrototype", 0, &JSCSSStyleSheetPrototypeTable };

JSObject* JSCSSStyleSheetPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleSheetPrototype>(exec, "[[JSCSSStyleSheet.prototype]]");
}

bool JSCSSStyleSheetPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleSheet::info = { "CSSStyleSheet", &JSStyleSheet::info, &JSCSSStyleSheetTable };

JSCSSStyleSheet::JSCSSStyleSheet(JSObject* prototype, CSSStyleSheet* impl)
    : JSStyleSheet(prototype, impl)
{
}

bool JSCSSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheet, Base>(exec, &JSCSSStyleSheetTable, this, propertyName, slot);
}

JSValue* JSCSSStyleSheet::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case OwnerRuleAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());
        return toJS(exec, WTF::getPtr(imp->ownerRule()));
    }
    case CssRulesAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());
        return toJS(exec, WTF::getPtr(imp->cssRules()));
    }
    case RulesAttrNum: {
        CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(impl());
        return toJS(exec, WTF::getPtr(imp->rules()));
    }
    }
    return 0;
}

JSValue* jsCSSStyleSheetPrototypeFunctionInsertRule(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleSheet::info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisObj);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String rule = args[0]->toString(exec);
    unsigned index = args[1]->toInt32(exec);


    KJS::JSValue* result = jsNumber(imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleSheetPrototypeFunctionDeleteRule(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleSheet::info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisObj);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCSSStyleSheetPrototypeFunctionAddRule(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleSheet::info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisObj);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String selector = args[0]->toString(exec);
    String style = args[1]->toString(exec);

    int argsCount = args.size();
    if (argsCount < 3) {

        KJS::JSValue* result = jsNumber(imp->addRule(selector, style, ec));
        setDOMException(exec, ec);
        return result;
    }

    unsigned index = args[2]->toInt32(exec);


    KJS::JSValue* result = jsNumber(imp->addRule(selector, style, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleSheetPrototypeFunctionRemoveRule(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleSheet::info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisObj);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);

    imp->removeRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
