/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleRule.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSStyleRule.h"
#include "JSCSSStyleDeclaration.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSStyleRuleTableEntries[] =
{
    { "selectorText", { (intptr_t)JSCSSStyleRule::SelectorTextAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSCSSStyleRule::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "style", { (intptr_t)JSCSSStyleRule::StyleAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSStyleRuleTable = 
{
    3, 8, JSCSSStyleRuleTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSCSSStyleRuleConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSStyleRuleConstructorTable = 
{
    3, 1, JSCSSStyleRuleConstructorTableEntries, 0
};

class JSCSSStyleRuleConstructor : public DOMObject {
public:
    JSCSSStyleRuleConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSStyleRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSStyleRuleConstructor::info = { "CSSStyleRuleConstructor", 0, &JSCSSStyleRuleConstructorTable };

bool JSCSSStyleRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleRuleConstructor, DOMObject>(exec, &JSCSSStyleRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSStyleRuleConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSStyleRulePrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSStyleRulePrototypeTable = 
{
    3, 1, JSCSSStyleRulePrototypeTableEntries, 0
};

const ClassInfo JSCSSStyleRulePrototype::info = { "CSSStyleRulePrototype", 0, &JSCSSStyleRulePrototypeTable };

JSObject* JSCSSStyleRulePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleRulePrototype>(exec, "[[JSCSSStyleRule.prototype]]");
}

const ClassInfo JSCSSStyleRule::info = { "CSSStyleRule", &JSCSSRule::info, &JSCSSStyleRuleTable };

JSCSSStyleRule::JSCSSStyleRule(JSObject* prototype, CSSStyleRule* impl)
    : JSCSSRule(prototype, impl)
{
}

bool JSCSSStyleRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleRule, Base>(exec, &JSCSSStyleRuleTable, this, propertyName, slot);
}

JSValue* JSCSSStyleRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case SelectorTextAttrNum: {
        CSSStyleRule* imp = static_cast<CSSStyleRule*>(impl());
        return jsStringOrNull(imp->selectorText());
    }
    case StyleAttrNum: {
        CSSStyleRule* imp = static_cast<CSSStyleRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSStyleRule::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSCSSStyleRule, Base>(exec, propertyName, value, &JSCSSStyleRuleTable, this);
}

void JSCSSStyleRule::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case SelectorTextAttrNum: {
        CSSStyleRule* imp = static_cast<CSSStyleRule*>(impl());
        ExceptionCode ec = 0;
        imp->setSelectorText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSCSSStyleRule::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleRuleConstructor>(exec, "[[CSSStyleRule.constructor]]");
}


}
