/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleDeclaration.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "AtomicString.h"
#include "CSSRule.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSRule.h"
#include "JSCSSValue.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSStyleDeclarationTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "length", { (intptr_t)JSCSSStyleDeclaration::LengthAttrNum }, DontDelete|ReadOnly, 0, &JSCSSStyleDeclarationTableEntries[9] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cssText", { (intptr_t)JSCSSStyleDeclaration::CssTextAttrNum }, DontDelete, 0, &JSCSSStyleDeclarationTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "parentRule", { (intptr_t)JSCSSStyleDeclaration::ParentRuleAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSCSSStyleDeclaration::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationTable = 
{
    3, 10, JSCSSStyleDeclarationTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSCSSStyleDeclarationConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationConstructorTable = 
{
    3, 1, JSCSSStyleDeclarationConstructorTableEntries, 0
};

class JSCSSStyleDeclarationConstructor : public DOMObject {
public:
    JSCSSStyleDeclarationConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSStyleDeclarationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSStyleDeclarationConstructor::info = { "CSSStyleDeclarationConstructor", 0, &JSCSSStyleDeclarationConstructorTable };

bool JSCSSStyleDeclarationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleDeclarationConstructor, DOMObject>(exec, &JSCSSStyleDeclarationConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSStyleDeclarationConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSStyleDeclarationPrototypeTableEntries[] =
{
    { "removeProperty", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionRemoveProperty }, DontDelete|Function, 1, &JSCSSStyleDeclarationPrototypeTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { "getPropertyPriority", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority }, DontDelete|Function, 1, 0 },
    { "getPropertyValue", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getPropertyShorthand", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand }, DontDelete|Function, 1, 0 },
    { "getPropertyCSSValue", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "isPropertyImplicit", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "item", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionItem }, DontDelete|Function, 1, 0 },
    { "setProperty", { (intptr_t)jsCSSStyleDeclarationPrototypeFunctionSetProperty }, DontDelete|Function, 3, 0 }
};

static const HashTable JSCSSStyleDeclarationPrototypeTable = 
{
    3, 17, JSCSSStyleDeclarationPrototypeTableEntries, 15
};

const ClassInfo JSCSSStyleDeclarationPrototype::info = { "CSSStyleDeclarationPrototype", 0, &JSCSSStyleDeclarationPrototypeTable };

JSObject* JSCSSStyleDeclarationPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleDeclarationPrototype>(exec, "[[JSCSSStyleDeclaration.prototype]]");
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleDeclaration::info = { "CSSStyleDeclaration", 0, &JSCSSStyleDeclarationTable };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(JSObject* prototype, CSSStyleDeclaration* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCSSStyleDeclaration::~JSCSSStyleDeclaration()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSCSSStyleDeclarationTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSCSSStyleDeclaration>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<CSSStyleDeclaration*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSStyleDeclaration, Base>(exec, &JSCSSStyleDeclarationTable, this, propertyName, slot);
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(propertyName), slot);
}

JSValue* JSCSSStyleDeclaration::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CssTextAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());
        return jsStringOrNull(imp->cssText());
    }
    case LengthAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());
        return jsNumber(imp->length());
    }
    case ParentRuleAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());
        return toJS(exec, WTF::getPtr(imp->parentRule()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSStyleDeclaration::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    if (customPut(exec, propertyName, value))
        return;
    lookupPut<JSCSSStyleDeclaration, Base>(exec, propertyName, value, &JSCSSStyleDeclarationTable, this);
}

void JSCSSStyleDeclaration::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CssTextAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());
        ExceptionCode ec = 0;
        imp->setCssText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

void JSCSSStyleDeclaration::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CSSStyleDeclaration*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSCSSStyleDeclaration::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleDeclarationConstructor>(exec, "[[CSSStyleDeclaration.constructor]]");
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    String propertyName = args[0]->toString(exec);


    KJS::JSValue* result = jsStringOrNull(imp->getPropertyValue(propertyName));
    return result;
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    String propertyName = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getPropertyCSSValue(propertyName)));
    return result;
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionRemoveProperty(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String propertyName = args[0]->toString(exec);


    KJS::JSValue* result = jsStringOrNull(imp->removeProperty(propertyName, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    String propertyName = args[0]->toString(exec);


    KJS::JSValue* result = jsStringOrNull(imp->getPropertyPriority(propertyName));
    return result;
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionSetProperty(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String propertyName = args[0]->toString(exec);
    String value = valueToStringWithNullCheck(exec, args[1]);
    String priority = args[2]->toString(exec);

    imp->setProperty(propertyName, value, priority, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = jsStringOrNull(imp->item(index));
    return result;
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    String propertyName = args[0]->toString(exec);


    KJS::JSValue* result = jsStringOrNull(imp->getPropertyShorthand(propertyName));
    return result;
}

JSValue* jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(thisObj);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    String propertyName = args[0]->toString(exec);


    KJS::JSValue* result = jsBoolean(imp->isPropertyImplicit(propertyName));
    return result;
}


JSValue* JSCSSStyleDeclaration::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSStyleDeclaration* thisObj = static_cast<JSCSSStyleDeclaration*>(slot.slotBase());
    return jsStringOrNull(thisObj->impl()->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, CSSStyleDeclaration* obj)
{
    return cacheDOMObject<CSSStyleDeclaration, JSCSSStyleDeclaration, JSCSSStyleDeclarationPrototype>(exec, obj);
}
CSSStyleDeclaration* toCSSStyleDeclaration(KJS::JSValue* val)
{
    return val->isObject(&JSCSSStyleDeclaration::info) ? static_cast<JSCSSStyleDeclaration*>(val)->impl() : 0;
}

}
