/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSRuleList.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "CSSRule.h"
#include "CSSRuleList.h"
#include "JSCSSRule.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSRuleListTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "length", { (intptr_t)JSCSSRuleList::LengthAttrNum }, DontDelete|ReadOnly, 0, &JSCSSRuleListTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSCSSRuleList::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSCSSRuleListTable = 
{
    3, 5, JSCSSRuleListTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSCSSRuleListConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSRuleListConstructorTable = 
{
    3, 1, JSCSSRuleListConstructorTableEntries, 0
};

class JSCSSRuleListConstructor : public DOMObject {
public:
    JSCSSRuleListConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSRuleListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSRuleListConstructor::info = { "CSSRuleListConstructor", 0, &JSCSSRuleListConstructorTable };

bool JSCSSRuleListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRuleListConstructor, DOMObject>(exec, &JSCSSRuleListConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSRuleListConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSRuleListPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "item", { (intptr_t)jsCSSRuleListPrototypeFunctionItem }, DontDelete|Function, 1, 0 }
};

static const HashTable JSCSSRuleListPrototypeTable = 
{
    3, 2, JSCSSRuleListPrototypeTableEntries, 1
};

const ClassInfo JSCSSRuleListPrototype::info = { "CSSRuleListPrototype", 0, &JSCSSRuleListPrototypeTable };

JSObject* JSCSSRuleListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSRuleListPrototype>(exec, "[[JSCSSRuleList.prototype]]");
}

bool JSCSSRuleListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSRuleListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSRuleList::info = { "CSSRuleList", 0, &JSCSSRuleListTable };

JSCSSRuleList::JSCSSRuleList(JSObject* prototype, CSSRuleList* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSCSSRuleList::~JSCSSRuleList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSCSSRuleList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSCSSRuleListTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSCSSRuleList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSRuleList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSRuleList, Base>(exec, &JSCSSRuleListTable, this, propertyName, slot);
}

bool JSCSSRuleList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSRuleList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(propertyName), slot);
}

JSValue* JSCSSRuleList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        CSSRuleList* imp = static_cast<CSSRuleList*>(impl());
        return jsNumber(imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSRuleList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CSSRuleList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSCSSRuleList::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSRuleListConstructor>(exec, "[[CSSRuleList.constructor]]");
}

JSValue* jsCSSRuleListPrototypeFunctionItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSRuleList::info))
        return throwError(exec, TypeError);
    JSCSSRuleList* castedThisObj = static_cast<JSCSSRuleList*>(thisObj);
    CSSRuleList* imp = static_cast<CSSRuleList*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}


JSValue* JSCSSRuleList::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSRuleList* thisObj = static_cast<JSCSSRuleList*>(slot.slotBase());
    return toJS(exec, static_cast<CSSRuleList*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, CSSRuleList* obj)
{
    return cacheDOMObject<CSSRuleList, JSCSSRuleList, JSCSSRuleListPrototype>(exec, obj);
}
CSSRuleList* toCSSRuleList(KJS::JSValue* val)
{
    return val->isObject(&JSCSSRuleList::info) ? static_cast<JSCSSRuleList*>(val)->impl() : 0;
}

}
