/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSMediaRule.h"

#include <wtf/GetPtr.h>

#include "CSSMediaRule.h"
#include "CSSRuleList.h"
#include "JSCSSRuleList.h"
#include "JSMediaList.h"
#include "MediaList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSMediaRuleTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSCSSMediaRule::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "media", { (intptr_t)JSCSSMediaRule::MediaAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cssRules", { (intptr_t)JSCSSMediaRule::CssRulesAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSMediaRuleTable = 
{
    3, 8, JSCSSMediaRuleTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSCSSMediaRuleConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSMediaRuleConstructorTable = 
{
    3, 1, JSCSSMediaRuleConstructorTableEntries, 0
};

class JSCSSMediaRuleConstructor : public DOMObject {
public:
    JSCSSMediaRuleConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSCSSMediaRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSMediaRuleConstructor::info = { "CSSMediaRuleConstructor", 0, &JSCSSMediaRuleConstructorTable };

bool JSCSSMediaRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRuleConstructor, DOMObject>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSMediaRuleConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSMediaRulePrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "deleteRule", { (intptr_t)jsCSSMediaRulePrototypeFunctionDeleteRule }, DontDelete|Function, 1, 0 },
    { "insertRule", { (intptr_t)jsCSSMediaRulePrototypeFunctionInsertRule }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSCSSMediaRulePrototypeTable = 
{
    3, 4, JSCSSMediaRulePrototypeTableEntries, 3
};

const ClassInfo JSCSSMediaRulePrototype::info = { "CSSMediaRulePrototype", 0, &JSCSSMediaRulePrototypeTable };

JSObject* JSCSSMediaRulePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSMediaRulePrototype>(exec, "[[JSCSSMediaRule.prototype]]");
}

bool JSCSSMediaRulePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSMediaRule::info = { "CSSMediaRule", &JSCSSRule::info, &JSCSSMediaRuleTable };

JSCSSMediaRule::JSCSSMediaRule(JSObject* prototype, CSSMediaRule* impl)
    : JSCSSRule(prototype, impl)
{
}

bool JSCSSMediaRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, slot);
}

JSValue* JSCSSMediaRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case MediaAttrNum: {
        CSSMediaRule* imp = static_cast<CSSMediaRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->media()));
    }
    case CssRulesAttrNum: {
        CSSMediaRule* imp = static_cast<CSSMediaRule*>(impl());
        return toJS(exec, WTF::getPtr(imp->cssRules()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCSSMediaRule::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSMediaRuleConstructor>(exec, "[[CSSMediaRule.constructor]]");
}

JSValue* jsCSSMediaRulePrototypeFunctionInsertRule(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSMediaRule::info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(thisObj);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String rule = args[0]->toString(exec);
    unsigned index = args[1]->toInt32(exec);


    KJS::JSValue* result = jsNumber(imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSMediaRulePrototypeFunctionDeleteRule(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSMediaRule::info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(thisObj);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
