/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSAttr.h"

#include <wtf/GetPtr.h>

#include "Attr.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Element.h"
#include "JSCSSStyleDeclaration.h"
#include "JSElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSAttrTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ownerElement", { (intptr_t)JSAttr::OwnerElementAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "name", { (intptr_t)JSAttr::NameAttrNum }, DontDelete|ReadOnly, 0, &JSAttrTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { "value", { (intptr_t)JSAttr::ValueAttrNum }, DontDelete, 0, 0 },
    { "style", { (intptr_t)JSAttr::StyleAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "specified", { (intptr_t)JSAttr::SpecifiedAttrNum }, DontDelete|ReadOnly, 0, &JSAttrTableEntries[17] },
    { "constructor", { (intptr_t)JSAttr::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSAttrTable = 
{
    3, 18, JSAttrTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSAttrConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSAttrConstructorTable = 
{
    3, 1, JSAttrConstructorTableEntries, 0
};

class JSAttrConstructor : public DOMObject {
public:
    JSAttrConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSAttrPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSAttrConstructor::info = { "AttrConstructor", 0, &JSAttrConstructorTable };

bool JSAttrConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAttrConstructor, DOMObject>(exec, &JSAttrConstructorTable, this, propertyName, slot);
}

JSValue* JSAttrConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSAttrPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSAttrPrototypeTable = 
{
    3, 1, JSAttrPrototypeTableEntries, 0
};

const ClassInfo JSAttrPrototype::info = { "AttrPrototype", 0, &JSAttrPrototypeTable };

JSObject* JSAttrPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSAttrPrototype>(exec, "[[JSAttr.prototype]]");
}

const ClassInfo JSAttr::info = { "Attr", &JSEventTargetNode::info, &JSAttrTable };

JSAttr::JSAttr(JSObject* prototype, Attr* impl)
    : JSEventTargetNode(prototype, impl)
{
}

bool JSAttr::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAttr, Base>(exec, &JSAttrTable, this, propertyName, slot);
}

JSValue* JSAttr::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NameAttrNum: {
        Attr* imp = static_cast<Attr*>(impl());
        return jsStringOrNull(imp->name());
    }
    case SpecifiedAttrNum: {
        Attr* imp = static_cast<Attr*>(impl());
        return jsBoolean(imp->specified());
    }
    case ValueAttrNum: {
        Attr* imp = static_cast<Attr*>(impl());
        return jsStringOrNull(imp->value());
    }
    case OwnerElementAttrNum: {
        Attr* imp = static_cast<Attr*>(impl());
        return toJS(exec, WTF::getPtr(imp->ownerElement()));
    }
    case StyleAttrNum: {
        Attr* imp = static_cast<Attr*>(impl());
        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSAttr::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSAttr, Base>(exec, propertyName, value, &JSAttrTable, this);
}

void JSAttr::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ValueAttrNum: {
        setValue(exec, value);
        break;
    }
    }
}

JSValue* JSAttr::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSAttrConstructor>(exec, "[[Attr.constructor]]");
}

Attr* toAttr(KJS::JSValue* val)
{
    return val->isObject(&JSAttr::info) ? static_cast<JSAttr*>(val)->impl() : 0;
}

Attr* JSAttr::impl() const
{
    return static_cast<Attr*>(Base::impl());
}

}
