#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from settings import *

import gtk
import hildonhelp
import osso

osso_context = osso.Context('com.quickclip.Quickclip','.5', False)

class Settings_Dialog:
   def __init__(self):
      self.settings = Settings().load()

   def settings_dialog(self,widget,data=None):

      settings_dialog = gtk.Dialog("Quick Clip Settings",None,gtk.DIALOG_MODAL)
      ok_button = settings_dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = settings_dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
      reset_button = settings_dialog.add_button("Reset", 42)

      self.path_entry = gtk.Entry()
      path_button = gtk.Button("Browse")
      self.view_entry = gtk.Entry()
      self.edit_entry = gtk.Entry()

      self.path_entry.set_width_chars(30)
      self.view_entry.set_width_chars(30)
      self.edit_entry.set_width_chars(30)

      self.path_entry.set_text(self.settings['path'])
      self.view_entry.set_text(self.settings['view_program'])
      self.edit_entry.set_text(self.settings['edit_program'])

      self.use_date_stamp_checkbutton = gtk.CheckButton("Use Date Stamp")
      self.use_separater_checkbutton = gtk.CheckButton("Use Separater")

      self.combobox = gtk.combo_box_new_text()
      self.combobox.set_size_request(300, -1)
      self.combobox.append_text("Top")
      self.combobox.append_text("Bottom")

      ok_button.connect('clicked', self.settings_callback)
      reset_button.connect('clicked', Settings().write_defaults)
      path_button.connect('clicked', self.path_button_callback)

      self.use_date_stamp_checkbutton.set_active(self.settings['use_date_stamp'])
      self.use_separater_checkbutton.set_active(self.settings['use_separater'])

      self.combobox.set_active(self.settings['default_menu_positioning'])

      path_hbox = gtk.HBox()
      path_button_hbox = gtk.HBox()
      view_hbox = gtk.HBox()
      edit_hbox = gtk.HBox()
      checkbox_hbox = gtk.HBox()
      combobox_hbox = gtk.HBox()

      path_hbox.pack_start(gtk.Label("Storage Path:"), False, 5, 10)
      path_hbox.pack_end(self.path_entry)
      view_hbox.pack_start(gtk.Label("View Program:"), False, 5, 5)
      view_hbox.pack_end(self.view_entry)
      edit_hbox.pack_start(gtk.Label("Edit Program:"), False, 5, 9)
      edit_hbox.add(self.edit_entry)
      checkbox_hbox.pack_start(self.use_date_stamp_checkbutton, False, 5, 70)
      checkbox_hbox.pack_end(self.use_separater_checkbutton, False, 5, 70)
      combobox_hbox.pack_start(gtk.Label("Options/History Displayed:"), False, 5, 60)
      combobox_hbox.pack_end(self.combobox, False, 5, 70)

      path_button_hbox.pack_start(path_hbox)
      path_button_hbox.pack_end(path_button)

      settings_dialog.vbox.pack_start(path_button_hbox, True, 15, 8)
      settings_dialog.vbox.pack_start(view_hbox, True, 15, 8)
      settings_dialog.vbox.pack_start(edit_hbox, True, 15, 8)
      settings_dialog.vbox.pack_start(checkbox_hbox, True, 15, 8)
      settings_dialog.vbox.pack_end(combobox_hbox, True, 10, 15)

      hildonhelp.help_dialog_help_enable(settings_dialog, "osso_quickclip_settings", osso_context)

      settings_dialog.show_all()
      settings_dialog.run()     
      settings_dialog.destroy()

   def path_button_callback(self, widget):
      dialog = gtk.FileChooserDialog("Choose Path", None, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, (gtk.STOCK_OPEN, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
      response = dialog.run()

      if response == gtk.RESPONSE_OK:
         path = dialog.get_filename()
         if path == "/":
            pass
         else:
            path = path + "/"
      else:
         dialog.destroy()
         return None

      dialog.destroy()
      self.path_entry.set_text(path)

# Settings Dialog entry callback

   def settings_callback(self, widget):
      path = self.path_entry.get_text()
      view_program = self.view_entry.get_text()
      edit_program = self.edit_entry.get_text()
      use_date_stamp = self.use_date_stamp_checkbutton.get_active()
      use_separater = self.use_separater_checkbutton.get_active()
      default_menu_positioning = self.combobox.get_active()

      Settings().write(path, view_program, edit_program, use_date_stamp, use_separater, default_menu_positioning)
