/**
 * python-launcher.h
 * Header file containing common functions.
 *
 * Copyright (C) 2005-2008 INdT - Instituto Nokia de Tecnologia
 *
 * Contact: Luciano Miguel Wolf <luciano.wolf@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef __PYTHON_LAUNCHER_H__
#define __PYTHON_LAUNCHER_H__

#define PL_STOP_DAEMON 66
#define PL_SOCK_READY "R"

#define PL_DEFAULT_PATH "/usr/bin/python-launcher-daemon"
#define PYTHON_DEFAULT "/usr/bin/python2.5"
#define DAEMON_CONF_FILE "/etc/python-launcher/daemon.conf"

#define PL_SOCK_PATH "/tmp/python_launcher"
#define PL_LOADOPT_FILE ".pylauncher"
/* TODO: support size limit on messages
#define PL_MAX_MSG_SIZE 200 */

/* Informs pygtk to avoid _init(). This will allow to configure
 * display connection only after app fork 
 */
#define DAEMON_CONF "python_launcher_enabled = 1; import gtk"

typedef enum {
    PL_DISABLED = 0,
    PL_STARTUP,
    PL_PYTHON_APP
} load_type;

load_type pl_get_load_opt(void);

#endif // __PYTHON_LAUNCHER_H__

/* vim:et:sw=4:ts=4:co=80
 */
