#!/usr/bin/env python
#
# This file is part of Python Download Manager
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Author: Kenneth Christiansen <kenneth.christiansen@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import sys
import ecore
import dbus

try:
    from e_dbus import DBusEcoreMainLoop
    DBusEcoreMainLoop(set_as_default=True)
except:
    import dbus.ecore

from downloadmanager.client import DownloadManager
from downloadmanager.constants import DownloadState


if __name__ == "__main__":
    if len(sys.argv) == 3:

        download_mger = DownloadManager()
        down_item = download_mger.add(sys.argv[1], sys.argv[2])

        def process_input(down_item):
            char = raw_input("Action [p/c/s/q]: ")
            if char == 'p':
                down_item.pause()
            elif char == 'c':
                down_item.cancel()
            elif char == 's':
                down_item.start()
            elif char == 'q':
                ecore.main_loop_quit()
            return True

        def _on_state_changed(down_item, state):
            if state == DownloadState.IN_PROGRESS:
                down_item.timer = ecore.timer_add(1.0, print_progress,
                                                  down_item)
            elif state == DownloadState.CANCELLED:
                down_item.timer.delete()
                print "download was cancelled"
            elif state == DownloadState.COMPLETED:
                down_item.timer.delete()
                size, total_size = down_item.get_progress()
                print size, total_size
                print "download was completed"
            elif state == DownloadState.PAUSED:
                down_item.timer.delete()
                print "download was paused"
            elif state == DownloadState.EXCEPTION:
                print down_item.get_exception_info()
                ecore.main_loop_quit()

        down_item.on_state_changed_add(_on_state_changed)
        down_item.timeout_id = -1
        ecore.timer_add(1.0, process_input, down_item)

        def print_progress(down_item):
            size, total_size = down_item.get_progress()
            print size, total_size
            return True

        print "press p for pause, c for cancel, s for start and q for quit. " \
              "All followed by enter"

        ecore.main_loop_begin()
    else:
        print "Usage:"
        print "\t%s <url> <filepath>" % sys.argv[0]
        sys.exit(2)
