#include "window-ipc.h"
#include <stdio.h>
#include <unistd.h>

#define CHAR_TO_VALUE(the_char) \
	(((the_char) >= '0' && (the_char) <= '9') \
		? ((the_char) - '0') \
		: ((the_char) >= 'a' && (the_char) <= 'f') \
			? ((the_char) - 'a' + 10) \
			:	((the_char) >= 'A' && (the_char) <= 'F') \
				? ((the_char) - 'A' + 10) \
				: 0)

void
write_window_id(int fd, guint window_id)
{
	int Nix;
	char buf[3] = {0, 0, 0};

	for (Nix = 0 ; Nix < sizeof(guint) ; Nix++) {
		g_snprintf(buf, 3, "%02x", (window_id & 0xff));
		write(fd, buf, 2);
		window_id = window_id >> 8;
	}

	write(fd, "\0", 1);
}

guint
read_window_id(int fd)
{
	guint window_id = 0;
	int Nix;
	char buf[3] = {0, 0, 0}, val;

	for (Nix = 0 ; Nix < sizeof(guint) ; Nix++) {
		read(fd, buf, 2);
		val = (CHAR_TO_VALUE(buf[0]) << 4) | CHAR_TO_VALUE(buf[1]);
		window_id |= ((((guint)val) & 0xff) << (Nix << 3));
	}

	read (fd, buf, 1); /* "\0" */

	return window_id;
}

char *
read_string(int fd)
{
    GString *str = NULL;
    char c = 0;

    if (-1 == fd) return NULL;
    if ((str = g_string_new("")) == NULL) return NULL;

    while (TRUE) {
    	if (read(fd, &c, 1) <= 0) break;
	if ('\0' == c) break; /* string ends in '\0' */

    	g_string_append_c(str, c);
    }

    return g_string_free(str, FALSE);
}
