#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of pidgin-carman.
#
#  pidgin-carman is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  pidgin-carman is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with pidgin-carman.  If not, see <http://www.gnu.org/licenses/>.


import dbus

_pidgin_bus_name = "im.pidgin.purple.PurpleService"
_pidgin_obj_path = "/im/pidgin/purple/PurpleObject"
_pidgin_iface    = "im.pidgin.purple.PurpleInterface"

if __name__ == '__main__':
	bus = dbus.SessionBus()
	obj = bus.get_object( _pidgin_bus_name, _pidgin_obj_path )
	purple = dbus.Interface( obj, _pidgin_iface )

	# get buddies info from each active account
	for accounts in purple.PurpleAccountsGetAllActive():
		print "account: %s" % (purple.PurpleAccountGetUsername(accounts))
		for buddies in purple.PurpleFindBuddies(accounts, ""):
			print "    buddy [%i]: %s (%s)" % (buddies, purple.PurpleBuddyGetAlias(buddies), purple.PurpleBuddyGetName(buddies))

	# get active conversations
	print "conversations:"
	for ims in purple.PurpleGetIms():
		print purple.PurpleConversationGetName(ims)
