/*
 *  Copyright (c) 2008 Andrew Olmsted <andrew.olmsted@gmail.com>
 *
 *  Parts of this file are based on Command Navigator which is
 *  Copyright (c) 2007-2008 Jiri Benc <jbenc@upir.cz>
 *  Parts of this file are based on hello-world-app
 *  Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PERSONAL_MENU_NAVIGATOR_PLUGIN_H
#define PERSONAL_MENU_NAVIGATOR_PLUGIN_H

#include <glib-object.h>

/* For Task Navigator plugins */
#include <libhildondesktop/tasknavigator-item.h>

G_BEGIN_DECLS

/* Common struct types declarations */
typedef struct _PersonalMenuNavigatorPlugin PersonalMenuNavigatorPlugin;
typedef struct _PersonalMenuNavigatorPluginClass PersonalMenuNavigatorPluginClass;
typedef struct _PersonalMenuNavigatorPluginPrivate PersonalMenuNavigatorPluginPrivate;

/* Common macros */
#define PERSONAL_MENU_TYPE_NAVIGATOR_PLUGIN            (personal_menu_navigator_plugin_get_type ())
#define PERSONAL_MENU_NAVIGATOR_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), PERSONAL_MENU_TYPE_NAVIGATOR_PLUGIN, PersonalMenuNavigatorPlugin))
#define PERSONAL_MENU_NAVIGATOR_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  PERSONAL_MENU_TYPE_NAVIGATOR_PLUGIN, PersonalMenuNavigatorPluginClass))
#define PERSONAL_MENU_IS_NAVIGATOR_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PERSONAL_MENU_TYPE_NAVIGATOR_PLUGIN))
#define PERSONAL_MENU_IS_NAVIGATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  PERSONAL_MENU_TYPE_NAVIGATOR_PLUGIN))
#define PERSONAL_MENU_NAVIGATOR_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  PERSONAL_MENU_TYPE_NAVIGATOR_PLUGIN, PersonalMenuNavigatorPluginClass))

/* Instance struct */
struct _PersonalMenuNavigatorPlugin
{
    TaskNavigatorItem tnitem;

    PersonalMenuNavigatorPluginPrivate *priv;
    GnomeVFSMonitorHandle  *fileMon;
    GtkWidget              *button;
    GtkWidget              *menu;
    osso_context_t         *context;
    guint                  updateTimeout;
    gboolean               popped;
    gint				   width;
    gint				   height;
};

/* Class struct */
struct _PersonalMenuNavigatorPluginClass
{
    TaskNavigatorItemClass parent_class;
};

GType  personal_menu_navigator_plugin_get_type  (void);
GtkWidget *personal_menu_button_new (int padding);


G_END_DECLS

#endif /* PERSONAL_MENU_NAVIGATOR_PLUGIN_H */
