#include <math.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtk/gtkstyle.h>
#include <libosso.h>
#include "mpuzzle.h"
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>
#include <sys/time.h>
#include <time.h>


/*
 * Deletes the last node in the stack for restricting number of undo 
 */


void free_last_element_in_undo_stack( struct pos **head )
{
	struct pos *ptrCurrent = *head;
	while(ptrCurrent->link!=NULL){

		if((ptrCurrent->link)->link==NULL){								
			struct pos *prtDelete = ptrCurrent->link;
			free(prtDelete);
			ptrCurrent->link = NULL; 
		}
		else{			
			ptrCurrent = ptrCurrent->link;				
		}
	}	

}
/*
 * Deletes all the elements present in the stack whenever new puzzle is generated
 */
void DeleteAllElements_in_undo_stack( struct pos **head )
{
	struct pos *deleteMe = *head;
	while(deleteMe)	{
		struct pos *next = deleteMe->link;
		free(deleteMe);
		deleteMe = next;
	}
	*head = NULL;
}



int main (int argc, char *argv[])
{
	osso_context_t* ctx = NULL;
	gtk_init (&argc, &argv);
	main_window = create_main_window ();
	ctx = osso_initialize("org.maemo.mpuzzle", "1.7.T18", TRUE, NULL);
	if (ctx == NULL) {
	/*	g_print("Failed to init LibOSSO\n");*/
		return 0;
	}
/*	g_print("LibOSSO Init done\n");*/
				
	gtk_widget_show_all (main_window);
	gtk_main ();
	return 0;
}

/*
 * Verify whether valid move or not 
 */
gboolean is_legal_slide (gint current_pos, gint vacant_pos)
{
	int current_x_pos, current_y_pos, vacant_x_pos, vacant_y_pos;
	int a, b;
	
	vacant_x_pos=vacant_pos%4 ; vacant_y_pos=(int)(vacant_pos/4);
	current_x_pos=current_pos%4 ; current_y_pos=(int)(current_pos/4);

	a=abs(vacant_x_pos - current_x_pos);
	b=abs(vacant_y_pos - current_y_pos);

	if ( ( (a==1 && b==0) || (a==0 && b==1) ) && !(a==1 && b==1) )  
		 return TRUE;
	else
		return FALSE;

}

/* 
 * Verity Whether game completed or not
 */  
gboolean has_player_won (void)
{
	int x;
	for (x=0; x<NOOFBUTTONS; x++)	
		if (x!= (gint) gtk_object_get_data(GTK_OBJECT(buttons[x]),"current_pos"))
	 	    return FALSE;
	
	gtk_widget_set_sensitive(undo_button,FALSE);	
	return TRUE;
}


 /* 
  * Action taken after button is clicked
  * & storting the positions in a stack for undo opertion
  */ 

void on_button_clicked (GtkWidget *button, gpointer user_data)
{
	int x_pos, y_pos;
	int current_pos;	
	gchar file_name[MAXSIZE];	
	
	struct pos *temp_undo_store_positions = (struct pos *)(malloc(sizeof(struct pos)));
	current_pos = (gint) gtk_object_get_data (GTK_OBJECT(button), "current_pos");

			
	if ( is_legal_slide(current_pos, vacant_pos) ){
       		gtk_widget_set_sensitive(undo_button,TRUE); /* Activate undo button*/
		max_undos_supported_count++;	
			
		x_pos = vacant_pos%CELLPOS; y_pos = (int)(vacant_pos/CELLPOS);
		
		 if(temp_undo_store_positions){    
		     temp_undo_store_positions->attach_in_vac_pos = vacant_pos;
	             temp_undo_store_positions->link = undo_store_positions;
		     undo_store_positions = temp_undo_store_positions;		     
		 }else{
			 g_print("unable to allocate memory from heap for undo strcut");			 
			 gtk_main_quit();
		 }

		no_of_valid_undos++;		
		gtk_container_remove (GTK_CONTAINER(table1), button);
		gtk_table_attach (GTK_TABLE (table1), 
			button, x_pos, x_pos + 1, y_pos, y_pos + 1,
			(GtkAttachOptions) GTK_FILL | GTK_EXPAND,
			(GtkAttachOptions) GTK_FILL | GTK_EXPAND,
			(GtkAttachOptions) 1, 1);

		gtk_object_set_data (GTK_OBJECT(button), "current_pos",(gpointer) vacant_pos);
		vacant_pos = current_pos;
		move_no++;
		
		if ( has_player_won() )	{
			gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, g_strdup_printf("Eureka You Won the Game with in %i Moves", move_no));		    	     gtk_widget_hide (table1);
			image = gtk_image_new ();
		        sprintf(file_name,"%swon.png",IMAGES_DIR);
		        gtk_image_set_from_file (GTK_IMAGE(image), file_name);
		        gtk_object_ref(GTK_OBJECT(table1));
		        gtk_container_remove (GTK_CONTAINER(alignment1), table1);
		        gtk_container_add (GTK_CONTAINER(alignment1), image);
		        gtk_widget_show (image);
		}else
			gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, g_strdup_printf("Move No.: %i", move_no));
	}
	else
		gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, "Wrong Move !");


	if(max_undos_supported_count > NO_OF_UNDOS_SUPPORTED){
		max_undos_supported_count=NO_OF_UNDOS_SUPPORTED;		
		free_last_element_in_undo_stack(&undo_store_positions);		
	}

}

GtkWidget* create_main_window (void)
{
  GtkWidget *main_window, *menubar1,*menuitem1,*menuitem1_menu,*new;
  GtkWidget *separatormenuitem1,*quit1,*menuitem4;
  GtkWidget *menuitem4_menu,*about1,*toolbar1;
  GtkWidget *new_button,*quit_button,*help_button;
  
  gint tmp_toolbar_icon_size, x, y, c=0;
  GtkAccelGroup *accel_group = gtk_accel_group_new ();
  GdkColor color = {0, 0xcc00, 0xec00, 0xff00};

  vacant_pos = 15; move_no=0;

  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (main_window), "MPuzzle-1.7.T18");
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (main_window), vbox1);

  menubar1 = gtk_menu_bar_new ();
  menuitem1 = gtk_menu_item_new_with_mnemonic ("_File");
  menuitem1_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem1), menuitem1_menu);
  new = gtk_image_menu_item_new_from_stock ("gtk-new", accel_group);
  separatormenuitem1 = gtk_separator_menu_item_new ();
  gtk_widget_set_sensitive (separatormenuitem1, FALSE);
  quit1 = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
  menuitem4 = gtk_menu_item_new_with_mnemonic ("_Help");
  menuitem4_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem4), menuitem4_menu);
  about1 = gtk_menu_item_new_with_mnemonic ("_About");

  gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (menubar1), menuitem1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), new);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), separatormenuitem1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), quit1);
  gtk_container_add (GTK_CONTAINER (menubar1), menuitem4);
  gtk_container_add (GTK_CONTAINER (menuitem4_menu), about1);

  toolbar1 = gtk_toolbar_new ();
  gtk_box_pack_start (GTK_BOX (vbox1), toolbar1, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar1), GTK_TOOLBAR_BOTH);
  tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar1));

  new_button = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-new");
  gtk_container_add (GTK_CONTAINER (toolbar1), new_button);

  quit_button = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-quit");
  gtk_container_add (GTK_CONTAINER (toolbar1), quit_button);

  help_button = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-help");
  gtk_container_add (GTK_CONTAINER (toolbar1), help_button);

  undo_button = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-undo");
  gtk_container_add (GTK_CONTAINER (toolbar1), undo_button);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_box_pack_start (GTK_BOX (vbox1), alignment1, TRUE, TRUE, 0);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 20, 20, 40, 40);

  
  table1 = gtk_table_new (4, 4, TRUE);
  gtk_container_add (GTK_CONTAINER (alignment1), table1);
  gtk_widget_modify_bg(main_window, GTK_STATE_NORMAL, &color);
  

  gtk_widget_set_sensitive(undo_button,FALSE);
  
  for (x=0; x<NOOFBUTTONS; x++) {
	  gchar *temp = g_strdup_printf ("%i", x+1);
	  buttons[x] = gtk_button_new_with_mnemonic (temp);
	  gtk_object_set_data (GTK_OBJECT(buttons[x]), "current_pos", (gpointer) x);
	  GdkColor dark = {0,0x6900,0xc600,0xff00};
	  GtkStyle * style = gtk_style_copy(buttons[x]->style);
	  style->bg[0] = dark;
	  style->bg[1] = dark;
	  style->bg[2] = dark;
	  style->bg[3] = dark;
	  style->bg[4] = dark;
	  gtk_widget_set_style(buttons[x], style);
	  g_free (temp);
  }
 
  for (x=0; x<CELLPOS; x++)
  	  for (y=0; y<CELLPOS; y++)
  		  if (!(x==3 && y==3))
			  gtk_table_attach (GTK_TABLE (table1), 
	  		  buttons[c++], y,y+1,x,x+1,
			  (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
      			  (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
      			  (GtkAttachOptions) 1, 1);
  
  for (x=0; x<NOOFBUTTONS; x++)
	gtk_signal_connect(GTK_OBJECT(buttons[x]), "clicked", GTK_SIGNAL_FUNC(on_button_clicked), (gpointer)x);

  statusbar1 = gtk_statusbar_new ();
  gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR(statusbar1), FALSE);
  gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, "Welcome to MARS Telecom");
  gtk_box_pack_start (GTK_BOX (vbox1), statusbar1, FALSE, FALSE, 0);

  g_signal_connect ((gpointer) main_window, "delete_event", G_CALLBACK (gtk_main_quit), NULL);
  g_signal_connect ((gpointer) new, "activate", G_CALLBACK (on_new_activate), NULL);
  g_signal_connect ((gpointer) new_button, "clicked", G_CALLBACK (on_new_activate), NULL);
  g_signal_connect ((gpointer) quit1, "activate", G_CALLBACK (on_quit_confirm), NULL); 
  g_signal_connect ((gpointer) about1, "activate", G_CALLBACK (on_about1_activate), NULL);
  g_signal_connect ((gpointer) quit_button, "clicked", G_CALLBACK (on_quit_confirm), NULL);
  g_signal_connect ((gpointer) help_button, "clicked", G_CALLBACK (on_about1_activate), NULL);
  g_signal_connect (GTK_OBJECT(undo_button),"clicked", GTK_SIGNAL_FUNC(on_undo_activate),NULL);
	
  gtk_window_add_accel_group (GTK_WINDOW (main_window), accel_group);

  return main_window;
  
}


void on_new_activate (GtkWidget *button,GtkMenuItem *menuitem, gpointer user_data)
{
	int i;
	int y,x,k,rand_pos;
	valid_moves_count=0;

	vacant_prev_pos = vacant_pos;
	vacant_pos=15;

	DeleteAllElements_in_undo_stack(&undo_store_positions);

	gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, "Welcome to MARS Telecom Puzzle");
	move_no=0;


	if (GTK_IS_WIDGET(image) && GTK_IS_WIDGET(image->parent)) {
		gtk_object_ref (GTK_OBJECT(image));
		gtk_container_remove (GTK_CONTAINER(alignment1), image); 
		gtk_container_add (GTK_CONTAINER(alignment1), table1);
		gtk_widget_show (table1);
	}
	

	for(x=0;x<NOOFBUTTONS;x++)
		alist[x]=x;
	
	gint row_pos,col_pos,req_pos;
 	gboolean ismoveValid;


	for(i=0;i<NOOFMOVES;i++){
	 
/*		movpos = abs(g_rand_int ( g_rand_new () )) % CELLPOS;	*/
		row_pos = (int) vacant_pos/CELLPOS;
		col_pos = vacant_pos%CELLPOS;	
		ismoveValid=FALSE;

		valid_move_positions(vacant_pos);
		
		rand_pos= abs(g_rand_int ( g_rand_new () ) ) % valid_moves_count ;
				
		switch(val_pos[rand_pos])
		{
			case UP:
				if(row_pos != ZERO){
					req_pos = (((row_pos-1)*CELLPOS) + col_pos);
					ismoveValid = TRUE;
				}
				break;			       
			case DOWN:
				if(row_pos != THREE){
					req_pos = (((row_pos + 1)* CELLPOS) + col_pos);
					ismoveValid=TRUE;
				}
				break;
			case LEFT:
				if(col_pos != ZERO){
					req_pos = (row_pos*CELLPOS) + (col_pos-1);
					ismoveValid = TRUE;
				}
				break;
			case RIGHT:
				if(col_pos != THREE){
					req_pos = (row_pos*CELLPOS) + (col_pos+1);
					ismoveValid = TRUE;
				}
				break;
		}
	
	
	
	if(ismoveValid){
		for(k=0;k<NOOFBUTTONS;k++)
				if(alist[k] == req_pos)
					break;					
		
			
		alist[k]=vacant_pos;
		vacant_pos = req_pos;
		
	}
}
	
	for(i=0;i<NOOFBUTTONS;i++){
		gtk_object_ref (GTK_OBJECT(buttons[i]));
		gtk_container_remove (GTK_CONTAINER(table1),buttons[i] );
		y=alist[i]%CELLPOS;
		x= (int) alist[i]/CELLPOS;	
		gtk_table_attach (GTK_TABLE (table1), 
				buttons[i], y,y+1,x,x+1,
				(GtkAttachOptions) GTK_FILL | GTK_EXPAND,
				(GtkAttachOptions) GTK_FILL | GTK_EXPAND,
				(GtkAttachOptions) 1, 1);
		gtk_object_set_data (GTK_OBJECT(buttons[i]), "current_pos", (gpointer) alist[i]);
	}	

	
}

		
/* Below Code to optimize the selections of slide position either UP,DOWN,LEFT, RIGHT 
 * selecting Random operation, only in the Valid moves                                  
 * argument vcpos -> vacant position
 * global variable val_pos[4]=> Stores valid move positions accordingly
 * globa variable valid_moves_count => counts max number of valid moves which will be used in on_new_activate () function   */

		
void valid_move_positions(gint vcpos) {
	int a= -1,b= -1,c= -1,d = -1;
	int i=0;
	valid_moves_count=0;
	gint row_pos,col_pos;
	col_pos = vcpos%4;
	row_pos = (int) vcpos/4;

	if((row_pos-1)<=3 && (row_pos-1)>=0){
		b = 4*(row_pos-1)+col_pos;			
		if(b!=-1){
			val_pos[i]=UP;
			i++;
			valid_moves_count++;
		}
	}
	if((row_pos+1)<=3 && (row_pos+1)>=0){
		a = 4*(row_pos+1)+col_pos;
		if(a!=-1){
			val_pos[i]=DOWN;
			i++;
			valid_moves_count++;
		}
	}
	if((col_pos-1)<=3 && (col_pos-1)>=0){
		d = 4*row_pos+(col_pos-1);
		if(d!=-1){
			val_pos[i]=LEFT;
			i++;
			valid_moves_count++;
		}
	}

	if((col_pos+1)<=3 && (col_pos+1)>=0){
		c = 4*row_pos+(col_pos+1);
		if(c!=-1){
			val_pos[i]=RIGHT;
			i++;
			valid_moves_count++;

		}
	}

}
		

/*
 * Action taken when undo button is pressed
 */ 

void on_undo_activate(GtkWidget *button,gpointer user_data)
{
	int k=0;
	gchar file_name[MAXSIZE];
	if(max_undos_supported_count>0) {
		max_undos_supported_count--;
	}
	gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, "Cannot Perform Undo ");
	if(max_undos_supported_count <= 0){
   	gtk_widget_set_sensitive(undo_button,FALSE);
	}
	

    if(no_of_valid_undos!=0){
		
        if(undo_store_positions==NULL){
		gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, "Cannot do Undo");		
        }
        else{
		gint x_pos,y_pos;
		x_pos = vacant_pos%CELLPOS; 
		y_pos = (int)(vacant_pos/CELLPOS);
		for(k=0;k<NOOFBUTTONS;k++){
			if((gint) gtk_object_get_data (GTK_OBJECT(buttons[k]), "current_pos") == (undo_store_positions->attach_in_vac_pos))
				break;
	}


	gtk_object_ref(GTK_OBJECT(table1));
	gtk_object_ref (GTK_OBJECT(buttons[k]));
	gtk_container_remove (GTK_CONTAINER(table1),buttons[k] );
	
        gtk_table_attach (GTK_TABLE (table1), buttons[k], 
			x_pos, x_pos + 1, y_pos, y_pos +1,
		 	(GtkAttachOptions) GTK_FILL | GTK_EXPAND, 
			(GtkAttachOptions) GTK_FILL | GTK_EXPAND,(GtkAttachOptions) 1, 1);

        gtk_object_set_data (GTK_OBJECT(buttons[k]), "current_pos", (gpointer) vacant_pos);
        
	vacant_pos = undo_store_positions->attach_in_vac_pos;
        move_no++;
	if ( has_player_won() ) {
		gtk_widget_set_sensitive(undo_button,FALSE);
		gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, g_strdup_printf("Eureka You Won the Game with in Moves : %i", move_no));
		gtk_widget_hide (table1);
		image = gtk_image_new ();
		sprintf(file_name,"%swon.png",IMAGES_DIR);
		gtk_image_set_from_file (GTK_IMAGE(image), file_name);
		gtk_object_ref(GTK_OBJECT(table1));
		gtk_container_remove (GTK_CONTAINER(alignment1), table1);
		gtk_container_add (GTK_CONTAINER(alignment1), image);
		gtk_widget_show (image);
		}else {
			gtk_statusbar_push (GTK_STATUSBAR(statusbar1), 0, g_strdup_printf("Move No.: %i", move_no));
		}

	struct pos *temp_undo_store_positions = undo_store_positions;
       	undo_store_positions = undo_store_positions->link;
	free(temp_undo_store_positions);
	}	
	no_of_valid_undos -=1;
    } 
}


void on_about1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *dialog;
		
	dialog = gtk_message_dialog_new_with_markup (GTK_WINDOW(main_window),
                                        GTK_DIALOG_MODAL,
                                        GTK_MESSAGE_INFO,
                                        GTK_BUTTONS_OK,
							"<b>Mpuzzle</b>\n\nSimple puzzle game\nHow to Play?\nClick on the number to move.\nIf you are able to sort numbers from 1 to 15\nthen you Win the Game!\nAuthor: Ashok Chiruvella, Ramulu Kambalapuram\nCompany: http://mars-india.com\nemail: ramulu.kambalapuram@mars-india.com");
	
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}


void on_quit_confirm (GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *dialog;
	gint result;
	dialog = gtk_message_dialog_new (GTK_WINDOW (main_window),
			GTK_DIALOG_MODAL,
			GTK_MESSAGE_QUESTION,
			GTK_BUTTONS_NONE,
			"Are you Sure want to Quit the Game");
	gtk_dialog_add_buttons (GTK_DIALOG (dialog),
			GTK_STOCK_YES, GTK_RESPONSE_YES,
			GTK_STOCK_NO, GTK_RESPONSE_NO,
			NULL);
	
	result = gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
	
	if (result == GTK_RESPONSE_YES)
		gtk_main_quit();
	
}

