#!/usr/bin/env python

# $HeadURL: http://svn.berlios.de/svnroot/repos/mirageiv/trunk/setup.py $
# $Id: setup.py 226 2007-11-26 03:27:29Z stonecrest $

from distutils.core import setup, Extension
import os

def removeall(path):
	if not os.path.isdir(path):
		return

	files=os.listdir(path)

	for x in files:
		fullpath=os.path.join(path, x)
		if os.path.isfile(fullpath):
			f=os.remove
			rmgeneric(fullpath, f)
		elif os.path.isdir(fullpath):
			removeall(fullpath)
			f=os.rmdir
			rmgeneric(fullpath, f)

def rmgeneric(path, __func__):
	try:
		__func__(path)
	except OSError, (errno, strerror):
		pass

# Create mo files:
if not os.path.exists("mo/"):
	os.mkdir("mo/")
for lang in ('it', 'de', 'pl', 'es', 'fr', 'ru'):
	pofile = "po/" + lang + ".po"
	mofile = "mo/" + lang + "/mirage.mo"
	if not os.path.exists("mo/" + lang + "/"):
		os.mkdir("mo/" + lang + "/")
	print "generating", mofile
	os.system("msgfmt %s -o %s" % (pofile, mofile))

setup(name='Mirage',
		version='0.9.2',
		description='A fast GTK+ image viewer',
		author='Scott Horowitz',
		author_email='stonecrest@gmail.com',
		url='http://mirageiv.berlios.de',
		classifiers=[
			'Environment :: X11 Applications',
			'Intended Audience :: End Users/Desktop',
			'License :: GNU General Public License (GPL)',
			'Operating System :: Linux',
			'Programming Language :: Python',
			'Topic :: Multimedia :: Graphics :: Viewers'
			],
#		py_modules = ['mirage'],
#		ext_modules = [Extension('imgfuncs', ['imgfuncs.c'])],
#		scripts = ['mirage'],
		data_files=[('share/mirage', ['README', 'COPYING', 'CHANGELOG', 'TRANSLATORS', 'pixmaps/stock_shuffle.png', 'pixmaps/stock_leave-fullscreen.png', 'pixmaps/stock_fullscreen.png', 'pixmaps/logo.png', 'mirage_blank.png', 'build/lib.linux-i686-2.5/imgfuncs.so', 'mirage', 'mirage.py']),
			('share/applications/hildon', ['mirage.desktop']),
			('share/icons/hicolor/26x26/hildon', ['mirage.png']),
			('share/icons/hicolor/scalable/hildon', ['pixmaps/mirage.png']),
			('share/dbus-1/services', ['mirage.service']),			
			('share/locale/ru/LC_MESSAGES', ['mo/ru/mirage.mo']),
			('share/locale/pl/LC_MESSAGES', ['mo/pl/mirage.mo']),
			('share/locale/fr/LC_MESSAGES', ['mo/fr/mirage.mo']),
			('share/locale/es/LC_MESSAGES', ['mo/es/mirage.mo']),
			('share/locale/de/LC_MESSAGES', ['mo/de/mirage.mo']),
			('share/locale/it/LC_MESSAGES', ['mo/it/mirage.mo'])],
		)
		
# Cleanup (remove /build, /mo, and *.pyc files:
print "Cleaning up..."
try:
	removeall("build/")
	os.rmdir("build/")
except:
	pass
try:
	removeall("mo/")
	os.rmdir("mo/")
except:
	pass
try:
	for f in os.listdir("."):
		if os.path.isfile(f):
			if os.path.splitext(os.path.basename(f))[1] == ".pyc":
				os.remove(f)
except:
	pass	
