from Widget import Widget
from Pixmap import Pixmap
from theme import theme

import gtk


class ScrollPane(Widget):

    def __init__(self):

        self.__offset = (0, 0)
    
        Widget.__init__(self)
        self.__pane = gtk.DrawingArea()
        self.get_window().put(self.__pane, 0, 0)
        self.__pane.realize()
        self.set_screen(Pixmap(self.__pane.window))
        


    def _visibility_changed(self):
    
        if (self.may_render()):
            self.__pane.show()
        else:
            self.__pane.hide()


    def get_size(self):
    
        return self.get_parent().get_size()


    def render_this(self):
       
        x, y = self.get_screen_pos()
        w, h = self.get_size()
        screen = self.get_screen()
        
        print x, y, w, h
        self.get_window().move(self.__pane, x, y)
        self.__pane.set_size_request(w, h)


    def move(self, dx, dy):
    
        offx, offy = self.__offset
        #offx = max(0, offx + dx)
        #offy = max(0, offy + dy)
        offx += dx
        offy += dy
        print (offx, offy)
        self.__offset = (offx, offy)
        self.render()
