_SEPARATOR = "\t"


class MetaCache(object):
    """
    Class representing a caching meta data object.
    """

    def __init__(self, cachefile):
        """
        Creates a new meta data object which uses the given file for caching.
        If the cache exists, its contents will be loaded.
        """
    
        self.__cachefile = cachefile
        self.__keys = []
        self.__items = []
        
        self.__read_from_cache()



    def __read_from_cache(self):
    
        try:
            lines = open(self.__cachefile, "r").readlines()
        except:
            return
            
        # get headers
        header = lines.pop(0).strip()
        self.__keys = header.split(_SEPARATOR)
        
        self.__items = []
        for line in lines:
            parts = line.strip().split(_SEPARATOR)
            item = {}
            for i in range(len(parts)):
                key = self.__keys[i]
                value = parts[i]
                item[key] = value
            #end for
            self.__items.append(item)
        #end for
        
        
    def __write_to_cache(self):
    
        out = _SEPARATOR.join(self.__keys) + "\n"
        for item in self.__items:
            values = [ item[key] for key in self.__keys ]
            out += _SEPARATOR.join(values) + "\n"
        #end for
        
        try:
            open(self.__cachefile, "w").write(out)
        except:
            pass
            
        
    def get_items(self):
    
        return self.__items[:]
        
        
    def add_item(self, item):
    
        if (not self.__keys):            
            self.__keys = item.keys()
            self.__keys.sort()
            
        self.__items.append(item)
        
        
    def save(self):
    
        self.__write_to_cache()
        
