/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "UnitConversion.h"

#include <Lum/Panel.h>
#include <Lum/Text.h>

static UnitConversion::Prefs* prefs=new UnitConversion::Prefs();

UnitConversion::Prefs::Prefs()
 : Lum::Component::Prefs(L"UnitConversion")
{
  // no code
}

void UnitConversion::Prefs::Initialize()
{
  Lum::Component::Prefs::Initialize();

  frame=new Lum::OS::EmptyFrame();
}

UnitConversion::UnitConversion()
{
  SetPrefs(::prefs);
}

void UnitConversion::CalcSize()
{
  Lum::Panel *panel;
  Lum::Text  *text;

  panel=new Lum::VPanel();
  panel->SetFlex(true,true);

  text=new Lum::Text(L"Coming soon!",Lum::OS::Font::normal,Lum::Text::centered);
  text->SetFlex(true,true);
  panel->Add(text);

  container=panel;

  container->SetParent(this);
  container->CalcSize();

  minWidth=container->GetOMinWidth();
  minHeight=container->GetOMinHeight();
  width=container->GetOWidth();
  height=container->GetOHeight();

  Component::CalcSize();
}
