/*
  MathJinni - A simple formular calculator
  Copyright (C) 2006  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/String.h>

#include <Lum/OS/Main.h>

#include <Lum/About.h>
#include <Lum/Dialog.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>
#include <Lum/Tab.h>
#include <Lum/WindowGroup.h>

#include "Calc.h"
#include "Configuration.h"
#include "FormatConversion.h"
#include "Plot.h"
#include "UnitConversion.h"

#include "config.h"

static Lum::AppInfo info;

class MainWindow : public Lum::Dialog
{
private:
  std::list<ConfigPlugin*> plugins;

public:
  MainWindow()
  {
    AttachModel(GetOpenedAction());
    AttachModel(GetClosedAction());
  }

  ~MainWindow()
  {
    UnattachModel(GetClosedAction());
    UnattachModel(GetOpenedAction());
  }

  void PreInit()
  {
    Lum::About       *about;
    Lum::Panel       *panel;
    Lum::Tab         *tab;
    Lum::WindowGroup *wGroup;

    Calc             *calc;
    FormatConversion *formatConversion;
    Plot             *plot;
    UnitConversion   *unitConversion;

    wGroup=new Lum::WindowGroup();
    wGroup->SetFlex(true,true);

    panel=new Lum::VPanel();
    panel->SetFlex(true,true);

    tab=new Lum::Tab();
    tab->SetFlex(true,true);

    calc=new Calc();
    calc->SetFlex(true,true);

    tab->Add(L"Calc",calc);

    formatConversion=new FormatConversion();
    formatConversion->SetFlex(true,true);

    tab->Add(L"Format Conv.",formatConversion);

    unitConversion=new UnitConversion();
    unitConversion->SetFlex(true,true);

    tab->Add(L"Unit Conv.",unitConversion);

    plot=new Plot();
    plot->SetFlex(true,true);
    plugins.push_back(plot);

    tab->Add(L"Plot",plot);

    about=new Lum::About();
    about->SetAppInfo(info);

    tab->Add(L"About",about);

    panel->Add(tab);

    wGroup->SetMain(panel);
    SetTop(wGroup);

    Dialog::PreInit();
  }

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==GetOpenedAction() && GetOpenedAction()->IsFinished()) {
      LoadConfig(plugins);
    }
    else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
      SaveConfig(plugins);
    }

    Dialog::Resync(model,msg);
  }
};

class Main : public Lum::OS::MainDialog<MainWindow>
{
public:
  Main()
  {
    info.SetProgram(Lum::Base::StringToWString(PACKAGE_NAME));
    info.SetVersion(Lum::Base::StringToWString(PACKAGE_VERSION));
    info.SetDescription(L"Doing some magic with numbers...");
    info.SetAuthor(L"Tim Teulings");
    info.SetContact(L"Tim Teulings <tim@teulings.org>");
    info.SetCopyright(L"(c) 2007, Tim Teulings");
    info.SetLicense(L"GNU Public License (GPL)");
  }
};

LUM_MAIN(Main,L"MathJinni")
