/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Calc.h"

#include <Lum/Base/String.h>

#include <Lum/Panel.h>
#include <Lum/Space.h>
#include <Lum/TextValue.h>

#include "FunctionInput.h"
#include "Util.h"

static Calc::Prefs* prefs=new Calc::Prefs();

Calc::Prefs::Prefs()
 : Lum::Component::Prefs(L"Calc")
{
  // no code
}

void Calc::Prefs::Initialize()
{
  Lum::Component::Prefs::Initialize();

  frame=new Lum::OS::EmptyFrame();
}

Calc::Calc()
: calculate(new Lum::Model::Action()),
  history(new Lum::Model::ListTable(1)),
  calcInput(new Lum::Model::String(L"")),
  calcResult(new Lum::Model::String(L""))
{
  SetPrefs(::prefs);

  AttachModel(calculate);
}

Calc::~Calc()
{
  UnattachModel(calculate);
}

void Calc::Calculate()
{
  Parser::ReturnCode result;
  size_t             pos;
  Parser::Expression *expression;
  double             value;

  expression=parser.Parse(Lum::Base::WStringToString(calcInput->Get()),result,pos);

  if (result==Parser::OK) {
    Lum::Model::ListTable::StdEntry *entry;

    if (history->GetRows()==0 || history->GetString(1,1)!=calcInput->Get()) {
      entry=new Lum::Model::ListTable::StdEntry(history);
      entry->SetString(1,calcInput->Get());
      history->Prepend(entry);
    }

    expression->Calculate(value,result);

    this->calcResult->Set(DoubleToWStringFloat(value));

    /*
    std::cout << "---" << std::endl;
    std::cout << std::setprecision(20);
    std::cout.unsetf(std::ios::scientific|std::ios::fixed|std::ios::showpoint);
    std::cout << value << std::endl;
    std::cout.setf(std::ios::fixed);
    std::cout  << value << std::endl;
    std::cout.unsetf(std::ios::fixed);
    std::cout.setf(std::ios::scientific,std::ios::floatfield);
    std::cout  << value << std::endl;*/

    delete expression;
  }
  else {
    comboInput->GetString()->SetCursorPos(pos);
    this->calcResult->Set(GetErrorText(result));
  }
}

void Calc::CalcSize()
{
  FunctionInput  *input;
  Lum::Panel     *panel;
  Lum::TextValue *value;

  panel=new Lum::VPanel();
  panel->SetFlex(true,true);

  comboInput=new Lum::TextEditCombo();
  comboInput->SetFlex(true,false);
  comboInput->SetWidth(Lum::Base::Size::stdCharWidth,30);
  comboInput->RequestFocus();
  comboInput->SetModel(calcInput);
  comboInput->SetTableModel(history);
  comboInput->GetString()->SetReturnAction(calculate);
  comboInput->GetString()->SetRequestsKeyboard(false);
  panel->Add(comboInput);

  panel->Add(new Lum::VSpace());

  value=new Lum::TextValue();
  value->SetFlex(true,false);
  value->SetAlignment(Lum::TextValue::right);
  value->SetModel(calcResult);
  panel->Add(value);

  panel->Add(new Lum::VSpace());

  input=new FunctionInput();
  input->SetFlex(true,true);
  input->SetString(comboInput->GetString());
  input->SetCalculateAction(calculate);
  panel->Add(input);

  container=panel;

  container->SetParent(this);
  container->CalcSize();

  minWidth=container->GetOMinWidth();
  minHeight=container->GetOMinHeight();
  width=container->GetOWidth();
  height=container->GetOHeight();

  Component::CalcSize();
}

void Calc::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==calculate && calculate->IsFinished()) {
    Calculate();
  }

  Lum::Component::Resync(model,msg);
}

