/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "NumberInput.h"

#include <Lum/Base/String.h>

#include <Lum/Button.h>
#include <Lum/Dialog.h>
#include <Lum/Grid.h>

static NumberInput::Prefs* prefs=new NumberInput::Prefs();

NumberInput::Prefs::Prefs()
 : Lum::Component::Prefs(L"NumberInput")
{
  // no code
}

void NumberInput::Prefs::Initialize()
{
  Lum::Component::Prefs::Initialize();

  frame=new Lum::OS::EmptyFrame();
}

NumberInput::NumberInput()
 : string(NULL),
   focusInAction(new Lum::Model::Action()),
   focusOutAction(new Lum::Model::Action()),
   backspaceAction(new Lum::Model::Action()),
   clearAction(new Lum::Model::Action())
{
  SetPrefs(::prefs);

  AttachModel(focusInAction);
  AttachModel(focusOutAction);
  AttachModel(backspaceAction);
  AttachModel(clearAction);
}

NumberInput::~NumberInput()
{
  UnattachModel(clearAction);
  UnattachModel(backspaceAction);
  UnattachModel(focusOutAction);
  UnattachModel(focusInAction);
}

void NumberInput::AddString(Lum::String *string)
{
  assert(string!=NULL);

  string->SetFocusInAction(focusInAction);
  string->SetFocusOutAction(focusOutAction);
}

Lum::Object* NumberInput::CreateButton(const std::wstring& label, Lum::Model::Action *action) const
{
  Lum::Button *button;

  button=new Lum::Button();
  button->SetFlex(true,true);

  if (action!=NULL) {
    button->SetModel(action);
  }

  button->SetText(label);

  return button;
}

Lum::Object* NumberInput::CreateTextButton(const std::wstring& label, const std::wstring& text)
{
  Lum::Model::ActionRef action;

  action=new Lum::Model::Action();

  AttachModel(action);

  if (text.empty()) {
    actionTextMap[action.Get()]=label;
  }
  else {
    actionTextMap[action.Get()]=text;
  }

  return CreateButton(label,action);
}

void NumberInput::CalcSize()
{
  Lum::Grid *grid;

  grid=new Lum::Grid();
  grid->SetFlex(true,true);
  grid->SetSize(4,4);
  grid->SetEqualDimensions(true,true);
  grid->SetSpace(true,true);

  grid->SetObject(0,0,CreateTextButton(L"7"));
  grid->SetObject(1,0,CreateTextButton(L"8"));
  grid->SetObject(2,0,CreateTextButton(L"9"));
  grid->SetObject(3,0,CreateButton(L"<-",backspaceAction));

  grid->SetObject(0,1,CreateTextButton(L"4"));
  grid->SetObject(1,1,CreateTextButton(L"5"));
  grid->SetObject(2,1,CreateTextButton(L"6"));
  grid->SetObject(3,1,CreateButton(L"Clr",clearAction));

  grid->SetObject(0,2,CreateTextButton(L"1"));
  grid->SetObject(1,2,CreateTextButton(L"2"));
  grid->SetObject(2,2,CreateTextButton(L"3"));
  grid->SetObject(3,2,CreateTextButton(L"-"));

  grid->SetObject(0,3,CreateTextButton(L"0"));
  grid->SetObject(1,3,CreateTextButton(Lum::Base::GetDecimalPointWString()));
  grid->SetObject(2,3,CreateTextButton(L"E"));
  grid->SetObject(3,3,CreateTextButton(L"+"));

  container=grid;

  container->SetParent(this);
  container->CalcSize();

  minWidth=container->GetOMinWidth();
  minHeight=container->GetOMinHeight();
  width=container->GetOWidth();
  height=container->GetOHeight();

  Component::CalcSize();
}

void NumberInput::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==focusInAction && focusInAction->IsFinished()) {
    string=dynamic_cast<Lum::String*>(dynamic_cast<Lum::Dialog*>(GetWindow()->GetMaster())->GetFocus());
  }
  else if (model==focusOutAction && focusOutAction->IsFinished()) {
    string=NULL;
  }
  else if (model==backspaceAction && backspaceAction->IsFinished()) {
    if (string!=NULL) {
      string->ActionBackspace();
    }
  }
  else if (model==clearAction && clearAction->IsFinished()) {
    if (string!=NULL) {
      string->ActionEraseAll();
    }
  }
  else if (dynamic_cast<Lum::Model::Action*>(model)!=NULL &&
           dynamic_cast<Lum::Model::Action*>(model)->IsFinished()) {
    if (string!=NULL) {
      std::map<Lum::Model::Action*,std::wstring>::const_iterator iter;

      iter=actionTextMap.find(dynamic_cast<Lum::Model::Action*>(model));
      if (iter!=actionTextMap.end()) {
        string->ActionInsertString(iter->second);
      }
    }
  }

  Component::Resync(model,msg);
}

