#ifndef FORMATCONVERSION_H
#define FORMATCONVERSION_H

/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/String.h>

#include <Lum/String.h>

class FormatConversion : public Lum::Component
{
private:
  enum InputTarget {
    targetNone,
    targetBin,
    targetOct,
    targetDec,
    targetHex
  };

public:
  class Prefs : public Lum::Component::Prefs
  {
  public:
    Prefs();
    void Initialize();
  };

private:
  Lum::Model::StringRef binFormat;
  Lum::Model::StringRef octFormat;
  Lum::Model::StringRef decFormat;
  Lum::Model::StringRef hexFormat;
  bool                  formatConversion;

  Lum::Model::ActionRef binFocusIn;
  Lum::Model::ActionRef octFocusIn;
  Lum::Model::ActionRef decFocusIn;
  Lum::Model::ActionRef hexFocusIn;
  Lum::Model::ActionRef focusOut;

  Lum::Model::ActionRef digitsPressed[17];

  Lum::String          *bin;
  Lum::String          *oct;
  Lum::String          *dec;
  Lum::String          *hex;

  InputTarget           inputTarget;

private:
  void ConvertFromBin();
  void ConvertFromOct();
  void ConvertFromDec();
  void ConvertFromHex();

public:
  FormatConversion();
  ~FormatConversion();

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
