/*
 * This file is part of maptile-loader
 * Copyright (C) 2007  Pekka Rönkkö (pronkko@gmail.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef __MAPTILE_MODULE_MANAGER_H__
#define __MAPTILE_MODULE_MANAGER_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MAPTILE_TYPE_MODULE_MANAGER         (maptile_module_manager_get_type ())


#define MAPTILE_MODULE_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                         MAPTILE_TYPE_MODULE_MANAGER, \
                                         MaptileModuleManager))



#define MAPTILE_MODULE_MANAGER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), \
                                         MAPTILE_TYPE_MODULE_MANAGER, \
                                         MaptileModuleManagerClass))


#define MAPTILE_IS_MODULE_MANAGER(obj)      (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                         MAPTILE_TYPE_MODULE_MANAGER))


#define MAPTILE_IS_MODULE_MANAGER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE((k), \
                                         MAPTILE_TYPE_MODULE_MANAGER))


#define MAPTILE_MODULE_MANAGER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), \
                                         MAPTILE_TYPE_MODULE_MANAGER, \
                                         MaptileModuleManagerClass))

typedef struct _MaptileModuleManagerClass MaptileModuleManagerClass;

struct _MaptileModuleManager
{
  GObject  parent_instance;

  gchar   *module_path;
  GList   *modules;
};

struct _MaptileModuleManagerClass
{
  GObjectClass  parent_class;
};


GType   maptile_module_manager_get_type (void) G_GNUC_CONST;


G_END_DECLS

#endif /* __MAPTILE_MODULE_MANAGER_H__ */

