/*
 * This file is part of maptile-loader
 * Copyright (C) 2007  Pekka Rönkkö (pronkko@gmail.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef __MAPTILE_REPO_H__
#define __MAPTILE_REPO_H__

#include <glib-object.h>

G_BEGIN_DECLS


#define MAPTILE_TYPE_REPO         (maptile_repo_get_type ())
#define MAPTILE_REPO(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), \
                                 MAPTILE_TYPE_REPO, MaptileRepo))
#define MAPTILE_REPO_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), \
                                 MAPTILE_TYPE_REPO, MaptileRepoClass))
#define MAPTILE_IS_REPO(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), \
                                 MAPTILE_TYPE_REPO))
#define MAPTILE_IS_REPO_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), \
                                 MAPTILE_TYPE_REPO))
#define MAPTILE_REPO_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), \
                                 MAPTILE_TYPE_REPO, MaptileRepoClass))


typedef struct _MaptileRepo      MaptileRepo;
typedef struct _MaptileRepoClass MaptileRepoClass;

struct _MaptileRepo
{
  GObject  parent_instance;

  gchar *map_name; /* Map type name, e.g. GoogleStreet (class is GoogleMaps) */
  gchar *map_data_uri; /* Maptile server URI */
  gchar *map_cache_uri; /* Local cache URI */
/*
  guint tile_area_width;
  guint tile_area_height;
  guint tile_image_width;
  guint tile_image_height;

  gboolean orientation_support;
  gfloat default_orientation;
*/
  gboolean con_ic_needed; /* Do we need internet connection to fetch maptiles */

};

struct _MaptileRepoClass
{
    GObjectClass  parent_class;

    /* Repo type, e.g. GoogleMaps */
    const gchar *name;

    void (* get_tile) (MaptileRepo     *repo,
                       guint tilex,
                       guint tiley,
                       guint zoom,
                       gchar **tile);
};


GType       maptile_repo_get_type (void) G_GNUC_CONST;

MaptileRepo * maptile_repo_new      (GType          type);

void        maptile_repo_get_tile   (MaptileRepo     *repo,
                                     guint tilex,
                                     guint tiley,
                                     guint zoom,
                                     gchar **tile);

G_END_DECLS

#endif /* __MAPTILE_REPO_H_ */
