#!/usr/bin/env python2.5

#
# Maemo Plazes handler (C) 2007 Henri Bergius and Eero af Heurlin
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# MA  02110-1301, USA.
#

import glob
import os
from distutils.core import setup

# read the version from maemoplazer main program
maemoplazer_version = os.popen("cat src/maemoplazer/maemoplazer.py | grep ^__version__.*= | cut -d\" -f2").read().strip()

# translations
#languages = [ "en" ]
#translation_files = []

# add translated files to translations dictionary
#for l in languages:
#    translation_files.append( ("share/locale/%s/LC_MESSAGES" % l, [ "data/locale/%s/LC_MESSAGES/maemoplazer.mo" % l ]) )

# files to install
inst_images = [ 'data/maemoplazer.png' ] 
inst_dbus = [ 'data/maemoplazer.service' ]
inst_desktop = [ 'data/maemoplazer.desktop' ]
inst_geoclue = ['data/position_maemoplazer.desc' ]
inst_glade = [ 'data/maemoplazer.glade' ]

data_files = [
  ('share/pixmaps', inst_images),
  ('share/applications/hildon', inst_desktop),
  ('share/dbus-1/services', inst_dbus),
  ('share/geoclue/backend', inst_geoclue),
  ('share/maemoplazer', inst_glade),
  ('lib/python2.5/site-packages', [ 'src/SimpleGladeApp.py' ]),
]

setup(
  name         = 'maemoplazer',
  version      = maemoplazer_version,
  package_dir  = { '':'src' },
  packages     = [ 'pyplazer', 'maemoplazer' ],
  description  = 'Plazes geopositioning client for the Maemo platform',
  author       = 'Henri Bergius',
  author_email = 'henri.bergius@iki.fi',
  url          = 'https://garage.maemo.org/projects/maemoplazer',
  scripts      = [ 'bin/maemoplazer' ],
  data_files   = data_files
)

