#ifndef MSDK_PROTOCOL_
#define MSDK_PROTOCOL_

#define MAEMO_SDK_SERVICE_PORT 2973


/*
 *  maemo SDK Host/Tablet Communication Protocol,
 *  Version 0.9
 *
 */
#define PROTOCOL_TAG          "protocol=\"m-sdk 0.9\""

#define REPLY_OK                  "<" PROTOCOL_TAG " status=\"OK\">\n"
#define REPLY_OK_WITH_PUBLIC_KEY  "<" PROTOCOL_TAG " status=\"PUBLIC KEY OK\" "
#define REPLY_STATUS_ALL_OFF      "<" PROTOCOL_TAG " on=\"\">\n"
#define REPLY_STATUS              "<" PROTOCOL_TAG " on=\""

#define REPLY_ERROR_COMMAND   "<" PROTOCOL_TAG " status=\"ERROR\" message=\"Unrecognized command\">\n"
#define REPLY_ERROR_SETTING   "<" PROTOCOL_TAG " status=\"ERROR\" message=\"Unrecognized setting for service\">\n"
#define REPLY_ERROR_PROTOCOL  "<" PROTOCOL_TAG " status=\"ERROR\" message=\"Unsupported protocol or protocol version\">\n"


#define COMMAND_USB_NET_START       "<" PROTOCOL_TAG " service=\"usbnet\" setting=\"up\">\n"
#define COMMAND_USB_NET_STOP        "<" PROTOCOL_TAG " service=\"usbnet\" setting=\"down\">\n"
#define COMMAND_SBRSH_START         "<" PROTOCOL_TAG " service=\"sbrsh\" setting=\"up\">\n"
#define COMMAND_SBRSH_STOP          "<" PROTOCOL_TAG " service=\"sbrsh\" setting=\"down\">\n"
#define COMMAND_BACKLIGHT_ON_START  "<" PROTOCOL_TAG " service=\"backlight\" setting=\"up\">\n"
#define COMMAND_BACKLIGHT_ON_STOP   "<" PROTOCOL_TAG " service=\"backlight\" setting=\"down\">\n"
#define COMMAND_DISCONNECT          "<" PROTOCOL_TAG " service=\"disconnect\">\n"
#define COMMAND_QUIT_TABLET         "<" PROTOCOL_TAG " service=\"quit\">\n"
#define COMMAND_PING                "<" PROTOCOL_TAG " service=\"ping\">\n"
#define COMMAND_QUERY_STATUS        "<" PROTOCOL_TAG " service=\"status\">\n"

#define COMMAND_REMOTE_X_START      "<" PROTOCOL_TAG " service=\"remote-x\" setting=\"up\">\n"
#define COMMAND_REMOTE_X_STOP       "<" PROTOCOL_TAG " service=\"remote-x\" setting=\"down\">\n"
#define COMMAND_ADD_USER            "<" PROTOCOL_TAG " service=\"add-user\" setting=\""
#define COMMAND_ADD_TARGET          "<" PROTOCOL_TAG " service=\"add-target\" setting=\""
#define COMMAND_CHECK_USER          "<" PROTOCOL_TAG " service=\"check-user\" setting=\""
#define COMMAND_TRANSFER_KEYS       "<" PROTOCOL_TAG " service=\"transfer-keys\" setting=\""


#endif /* MSDK_PROTOCOL */
