/*
 * Copyright (c) 2007 Nokia Corporation
 * All rights reserved.
 *
 * Contact: Jukka-Pekka Iivonen <jukka-pekka.iivonen(at)nokia.com>
 *
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */


#include <config.h>

#include <signal.h>
#include <ctype.h>

#include "maemo-program.h"
#include "server-socket.h"
#include "protocol.h"
#include <string.h>
#include <libosso.h>


/*FIXME*/
gboolean state_usb_net  = FALSE;
gboolean state_sbrsh    = FALSE;
gboolean state_remote_x = FALSE;

GtkWidget *window;
GtkWidget *error_dialog;



void exit_handler( int );
gboolean start_server();

gboolean backlight_on;
gboolean remote_x_on;
gboolean sbrsh_on;

/*
 */
static void
add_user( gchar *username, gchar *uid, gchar *gid, gchar *passwd )
{
	GString *command;

	command = g_string_new( "" );
	g_string_append_printf( command, "sudo maemo-sdk-add-user %s %s %s %s", username, uid, gid, passwd );
	system( command->str );
	g_string_free( command, TRUE );
}

/*
 */
static void
add_user_finish( gchar *username, gchar *gid )
{
	GString *command;

	command = g_string_new( "" );
	g_string_append_printf( command, "sudo maemo-sdk-add-user-finish %s %s", username, gid );
	system( command->str );
	g_string_free( command, TRUE );
}


/*
 *  maemo SDK Actions
 *
 */

static void
poll_lcd()
{
	osso_rpc_t retval;

	osso_rpc_run_system( program->osso_context,
			     "com.nokia.mce",
			     "/com/nokia/mce/request",
			     "com.nokia.mce.request",
			     "req_display_state_on", &retval,
			     DBUS_TYPE_INVALID );
}

static gboolean
lcd_polling( gpointer dummy )
{
	if ( backlight_on ) {
		poll_lcd();
		return TRUE;
	}

	return FALSE;
}

/*
 * LCD Always ON Service
 */
void
set_backlight_service( gboolean setting_on )
{
	backlight_on = setting_on;

	if ( setting_on ) {
		set_button( "lcdbutton_on" );

		poll_lcd();
		g_timeout_add( 15 * 1000, (GSourceFunc) lcd_polling, NULL );
	} else {
		set_button( "lcdbutton_off" );
	}
}


/*
 * Send a reply message over the network.
 */
static void
protocol_reply( GIOChannel *channel, gchar *chars )
{
	GIOStatus status;
	GError   *err = NULL;
	gsize     pos;
	char     *p;

	/* Check that new line character is in the message. */
	g_assert( ( p = strchr( chars, '\n' ) ) != NULL );

	/* Check that there is no more new line characters in the message. */
	g_assert( strchr( p + 1, '\n' ) == NULL );

printf("Sending reply='%s'\n", chars);
	status = g_io_channel_write_chars( channel, chars, -1, &pos, &err );

	if ( status == G_IO_STATUS_ERROR ) {
                g_error( "Networking error: %s\n", err->message );

		return;
	}
	status = g_io_channel_flush( channel, &err );
	if ( status == G_IO_STATUS_ERROR )
	    	g_error( "Networking error: %s\n", err->message );
}

static GString *
parse_and_save_key( gchar *message )
{
	gchar *login, *uid, *gid, *passwd, *p;
	FILE  *in, *out;
	GString *filename;
	GString *reply;
	gchar    buf[1024], *client_ip, *server_ip;

	printf( "message=%s\n", message );

	/* Parse login name from the message. */
	p = strchr( message, ':' );
	if ( p == NULL ) {
		printf( "Login name missing from the trasfer keys message.\n" );
		return NULL;
	}
	*p = '\0';
	login = g_strdup( message );
	printf( "Login: %s\n", login );

	message = p + 1;

	/* Parse uid from the message. */
	p = strchr( message, ':' );
	if ( p == NULL ) {
		printf( "UID missing from the trasfer keys message.\n" );
		return NULL;
	}
	*p = '\0';
	uid = g_strdup( message );
	printf( "UID: %s\n", uid );

	message = p + 1;

	/* Parse gid from the message. */
	p = strchr( message, ':' );
	if ( p == NULL ) {
		printf( "GID missing from the trasfer keys message.\n" );
		return NULL;
	}
	*p = '\0';
	gid = g_strdup( message );
	printf( "GID: %s\n", gid );

	message = p + 1;

	/* Parse passwd from the message. */
	p = strchr( message, ':' );
	if ( p == NULL ) {
		printf( "Password missing from the trasfer keys message.\n" );
		return NULL;
	}
	*p = '\0';
	passwd = g_strdup( message );
	printf( "Password: %s\n", passwd );

	message = p + 1;


	/* Parse server IP from the message. */
	p = strchr( message, ':' );
	if ( p == NULL ) {
		printf( "Server IP missing from the trasfer keys message.\n" );
		return NULL;
	}
	*p = '\0';
	server_ip = g_strdup( message );
	printf( "Server IP: %s\n", server_ip );

	message = p + 1;

	/* Add the given user to the system. */
	add_user( login, uid, gid, passwd );


	/* Write the new /etc/sbrshd.conf */
	client_ip = server_socket_get_client_ip( server_socket );
	printf( "client IP=%s\n", client_ip );

	out = fopen( "/etc/sbrshd.conf", "w" );
	if ( out == NULL ) {
		printf( "Cannot open /etc/sbrshd.conf for writing.\n" );
		return NULL;
	}
	fprintf( out, "%s\n", client_ip );
	fclose( out );

	/* Fix the user access rights. */
	add_user_finish( login, gid );


	/* Read the public key for the reply message. */
	filename = g_string_new( "" );
	g_string_append_printf( filename, "/home/%s/.ssh/id_rsa.pub", login );

	reply = g_string_new( REPLY_OK_WITH_PUBLIC_KEY );
	g_string_append_printf( reply, "%s:", client_ip );

	in = fopen( filename->str, "r" );
	if ( in == NULL ) {
		printf( "Cannot open '%s' for reading.\n", filename->str );
		return NULL;
	}

	while ( NULL != ( p = fgets( buf, 1023, in ) ) ) {
		gchar *q = strchr( p, '\n' );
		if ( q != NULL )
			*q = 1;
		g_string_append_printf( reply, "%s", p );
	}		
	fclose( in );

	g_string_append_printf( reply, "\n" );
	g_free( client_ip );

	return reply;
}

/*
 * Network communication handling.  Checks the command message and replys.
 * Disconnects the channel if the connection is lost.
 *
 */
gboolean
event_cb(GIOChannel *source, GIOCondition condition, ServerSocket *server_socket)
{
	GError   *err = NULL;

	printf("read_cb here: %d\n", condition);

	if ( condition & G_IO_HUP ) {
		printf("Connection hang up!\n");

		server_socket_close_channel( server_socket, source );

		return FALSE;
	} else if ( condition == G_IO_IN ) {
		GIOStatus status;
		gsize     pos;
		GString  *buffer;

		buffer = g_string_new( "" );
		status = g_io_channel_read_line_string( source, buffer, &pos, &err );
	        if ( status == G_IO_STATUS_ERROR ) {
                	g_error ("Error reading: %s\n", err->message);
			g_string_free( buffer, TRUE );

			return TRUE;
		}
		printf( "Command: %s\n", buffer->str );

		/* Check if empty string. */
		for ( pos = 0; buffer->str[pos]; pos++ )
			if ( ! isspace( buffer->str[pos] ) )
				goto has_data;
		g_string_free( buffer, TRUE );

		return TRUE;
	has_data:
	
		if ( strstr( buffer->str, PROTOCOL_TAG ) == 0 ) {
			protocol_reply( source, REPLY_ERROR_PROTOCOL );
			goto not_ok_skipping;
		}

		if ( strncmp( buffer->str, COMMAND_REMOTE_X_START,
		              strlen( COMMAND_REMOTE_X_START ) ) == 0 ) {
			set_remote_x_service( TRUE );
		} else if ( strncmp( buffer->str, COMMAND_REMOTE_X_STOP,
				     strlen( COMMAND_REMOTE_X_STOP ) ) == 0 ) {
			set_remote_x_service( FALSE );
		} else if ( strncmp( buffer->str, COMMAND_ADD_TARGET,
				     strlen( COMMAND_ADD_TARGET ) ) == 0 ) {
			gchar *p, *q = buffer->str + strlen( COMMAND_ADD_TARGET );

			p = q;
			while ( *p && *p != '\"' )
				++p;

			if ( *p == '\"' ) {
				*p = '\0';
				add_target( q );
				*p = '\"';
			}
		} else if ( strncmp( buffer->str, COMMAND_SBRSH_START,
				     strlen( COMMAND_SBRSH_START ) ) == 0 ) {
			set_sbrsh_service( TRUE );
		} else if ( strncmp( buffer->str, COMMAND_SBRSH_STOP,
				     strlen( COMMAND_SBRSH_STOP ) ) == 0 ) {
			set_sbrsh_service( FALSE );
		} else if ( strncmp( buffer->str, COMMAND_BACKLIGHT_ON_START,
				     strlen( COMMAND_BACKLIGHT_ON_START ) ) == 0 ) {
			set_backlight_service( TRUE );
		} else if ( strncmp( buffer->str, COMMAND_BACKLIGHT_ON_STOP,
				     strlen( COMMAND_BACKLIGHT_ON_STOP ) ) == 0 ) {
			set_backlight_service( FALSE );
		} else if ( strncmp( buffer->str, COMMAND_USB_NET_START,
				     strlen( COMMAND_USB_NET_START ) ) == 0 ) {
			set_button( "usbbutton_on" );
		} else if ( strncmp( buffer->str, COMMAND_USB_NET_STOP,
				     strlen( COMMAND_USB_NET_STOP ) ) == 0 ) {
			set_button( "usbbutton_off" );
		} else if ( strncmp( buffer->str, COMMAND_CHECK_USER,
				     strlen( COMMAND_CHECK_USER ) ) == 0 ) {

		} else if ( strncmp( buffer->str, COMMAND_TRANSFER_KEYS,
				     strlen( COMMAND_TRANSFER_KEYS ) ) == 0 ) {
			GString *pub_key_reply = parse_and_save_key( buffer->str + strlen( COMMAND_TRANSFER_KEYS ) );

			if ( pub_key_reply != NULL ) {
				protocol_reply( source, pub_key_reply->str );
				g_string_free( pub_key_reply, TRUE );
			} else
				protocol_reply( source, REPLY_OK );
			return TRUE;
		} else if ( strncmp( buffer->str, COMMAND_DISCONNECT,
				     strlen( COMMAND_DISCONNECT ) ) == 0 ) {
			/* FIXME: TODO */
		} else if ( strncmp( buffer->str, COMMAND_QUIT_TABLET,
				     strlen( COMMAND_QUIT_TABLET ) ) == 0 ) {
			gtk_main_quit();
		} else if ( strncmp( buffer->str, COMMAND_PING,
				     strlen( COMMAND_PING ) ) == 0 ) {
			/* Do nothing, just reply <OK>. */
		} else if ( strncmp( buffer->str, COMMAND_QUERY_STATUS,
				     strlen( COMMAND_QUERY_STATUS ) ) == 0 ) {
			GString *reply = g_string_new( REPLY_STATUS );

			if ( remote_x_on )
				g_string_append_printf( reply, "remote-x," );

			if ( sbrsh_on )
				g_string_append_printf( reply, "sbrsh," );

			if ( backlight_on )
				g_string_append_printf( reply, "backlight," );

			g_string_append_printf( reply, "\">\n" );
			protocol_reply( source, reply->str );
			g_string_free( reply, TRUE );

			goto not_ok_skipping;
		} else {
			g_error( "Error: unknown command '%s'\n", buffer->str );
			protocol_reply( source, REPLY_ERROR_COMMAND );
			goto not_ok_skipping;
		}
		protocol_reply( source, REPLY_OK );
not_ok_skipping:
		g_string_free( buffer, TRUE );

	}

	return TRUE;
}

static gint
test_process(gchar *name)
{
	FILE    *in;
	char    *filename = "/tmp/.maemosdktest";
	char    *s;
	char     buf[256];
	GString *string;
	int      value;

	system( "ps -e > /tmp/.maemosdk1" );

	string = g_string_new( "cat /tmp/.maemosdk1 | grep " );
	g_string_append_printf( string, "%s | wc -l > %s", name, filename );
printf("Command=%s\n", string->str);
	system( string->str );
	g_string_free( string, TRUE );

	in = fopen( filename, "r" );
	if ( in == NULL )
		return -1;
	s = fgets( buf, 255, in );
	if ( s == NULL )
		return -1;
printf("Read: %s for %s value=%d\n", buf, name, atoi(buf));
	value = atoi( buf ); /* Decrease one that comes from the grepping */;

	return value;
}

static gboolean
initialize_state()
{
	GtkWidget *widget;
	gint       status;

	/* Initialize state of VNC buttons. */
	status = test_process( "x11vnc" );
	if ( status == -1 )
		return TRUE;

	if ( status )
		widget = lookup_widget( window, "vncbutton_on" );
	else
		widget = lookup_widget( window, "vncbutton_off" );
	if ( widget == NULL )
		return TRUE;
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( widget ), TRUE );
	remote_x_on = status;


	/* Initialize state of SBRSH buttons. */
	status = test_process( "sbrshd" );
	if ( status == -1 )
		return TRUE;
	if ( status )
		widget = lookup_widget( window, "sbrshbutton_on" );
	else
		widget = lookup_widget( window, "sbrshbutton_off" );
	if ( widget == NULL )
		return TRUE;
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( widget ), TRUE );
	sbrsh_on = status;


	/* Initialize state of LCD buttons. */
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( widget ), FALSE );
	backlight_on = FALSE;
	widget = lookup_widget( window, "lcdbutton_off" );
	if ( widget == NULL )
		return TRUE;
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( widget ), TRUE );

	/* Initialize state of USB networking buttons. */
/* FIXME: TODO */

	return FALSE;
}

/*
 * The main function.  The create_window1 function has been generated using Glade.
 * TabletProgram and ServerSocket objects are GObjects implemented using GOB2.
 */
int 
main(int argc, char *argv[])
{
	gboolean           status;

	const gchar *application_name = "Maemo SDK Tablet";
	const gchar *service_name     = "com.nokia.MaemoSDKTablet";
	const gchar *help_id          = "osso_MaemoSDKTablet_Content";

	const gchar *copyright        = "Copyright (c) 2007 by Nokia Corporation";
	const gchar *url              = "http://www.maemo.org";
	const gchar *web              = "www.maemo.org";
	const gchar *license          =
"Permission is hereby granted, free of charge, to any person\n"
"obtaining a copy of this software and associated documentation\n"
"files (the \"Software\"), to deal in the Software without\n"
"restriction, including without limitation the rights to use,\n"
"copy, modify, merge, publish, distribute, sublicense, and/or sell\n"
"copies of the Software, and to permit persons to whom the\n"
"Software is furnished to do so, subject to the following\n"
"conditions:\n"
"\n"
"The above copyright notice and this permission notice shall be\n"
"included in all copies or substantial portions of the Software.\n"
"\n"
"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
"EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES\n"
"OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n"
"NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\n"
"HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\n"
"WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n"
"FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\n"
"OTHER DEALINGS IN THE SOFTWARE.";

        g_type_init();
	g_thread_init( NULL );

        program = maemo_program_new( application_name, service_name,
				     help_id, argc, argv, NULL );
	maemo_program_set_about( program, copyright, license,
				  "Maemo SDK Tablet Manager.", 
				  NULL );
	maemo_program_set_about_website( program, url, web );


	/* Create the user interface. */  
        create_window1( program->window );
	error_dialog = create_error_dialog();
  	window = program->window;

	/* Eshtablish the server socket. */
	server_socket = server_socket_new( 2973, (GIOFunc) event_cb );

	if ( server_socket == NULL )
		g_assert( server_socket != NULL );

	/* Initialize radio buttons into their correct values. */
	status = initialize_state();
	g_assert( ! status );

	/* Go to the main loop. */
        maemo_program_main( program );

	server_socket_close( server_socket );
 
        return 0;
}

