#!/usr/bin/env python

import dbus, dbus.glib
import gobject
import os


IAP_NAME = os.environ["IAP"]
PAN_HOME = os.environ["PAN_HOME"]


def on_status_change(name, ctype, status, arg):

    if (name != IAP_NAME): return
    
    if (status == "CONNECTED"):
	# fire up PAN
	os.system("sh %s/pan-control connect &" % PAN_HOME)
    elif (status == "DISCONNECTING"):
	# shut down PAN
	os.system("sh %s/pan-control disconnect &" % PAN_HOME)
	
    
bus = dbus.SystemBus(private = True)
obj = bus.get_object("com.nokia.icd", "/com/nokia/icd")
icd = dbus.Interface(obj, "com.nokia.icd")
icd.connect_to_signal("status_changed", on_status_change)

loop = gobject.MainLoop()
loop.run()

