/**
  @file plugin.c

  Example plugin implementation
  <p>
  Copyright (c) 2005 INdT. All rights reserved.

  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
*/

#include <stdio.h>
#include <gtk/gtk.h>
#include <startup_plugin.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include "../protocol.h"

GameStartupInfo gs;
GConfClient *gcc = NULL;
GtkWidget *num_player_box, *level_box;
GtkWidget *deathmatch_check, *nomonster_check;

static GtkWidget *
load_plugin (void) {
  int num_player, level, deathmatch, nomonster;
  GtkWidget *alignment;
  GtkWidget *game_vbox, *game_hbox;
  GtkWidget *label;

  g_type_init();
  gcc = gconf_client_get_default();
  num_player = gconf_client_get_int(gcc, LXDOOM_NUMPLAYERS, NULL);
  level = gconf_client_get_int(gcc, LXDOOM_LEVEL, NULL);
  deathmatch = gconf_client_get_bool(gcc, LXDOOM_DEATHMATCH, NULL);
  nomonster = gconf_client_get_bool(gcc, LXDOOM_NOMONSTER, NULL);

  game_vbox = gtk_vbox_new (TRUE, 0);
  g_assert (game_vbox);

  game_hbox = gtk_hbox_new (TRUE, 10);
  g_assert (game_hbox);
  gtk_box_pack_start (GTK_BOX (game_vbox), game_hbox, TRUE, TRUE, 0);

  label = gtk_label_new ("Players");
  g_assert (label);
  alignment = gtk_alignment_new (1.0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), label);    
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  num_player_box = gtk_spin_button_new_with_range (2, 4, 1);
  g_assert (num_player_box);
  alignment = gtk_alignment_new (0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), num_player_box);    
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (num_player_box), num_player);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  label = gtk_label_new ("Level");
  g_assert (label);
  alignment = gtk_alignment_new (1.0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), label);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  level_box = gtk_spin_button_new_with_range (1, 9, 1);
  g_assert (level_box);
  alignment = gtk_alignment_new (0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), level_box);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (level_box), level);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  game_hbox = gtk_hbox_new (TRUE, 10);
  g_assert (game_hbox);
  gtk_box_pack_start (GTK_BOX (game_vbox), game_hbox, TRUE, TRUE, 0);

  label = gtk_label_new ("Death match");
  g_assert (label);
  alignment = gtk_alignment_new (1.0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), label);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  deathmatch_check = gtk_check_button_new ();
  g_assert (deathmatch_check);
  alignment = gtk_alignment_new (0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), deathmatch_check);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(deathmatch_check), deathmatch);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  label = gtk_label_new ("No monsters");
  g_assert (label);
  alignment = gtk_alignment_new (1.0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), label);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  nomonster_check = gtk_check_button_new ();
  g_assert (nomonster_check);
  alignment = gtk_alignment_new (0, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (alignment), nomonster_check);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(nomonster_check), nomonster);
  gtk_box_pack_start (GTK_BOX (game_hbox), alignment, TRUE, TRUE, 0);

  return game_vbox;
}

static void 
write_config (gchar *nick, gchar *ip) {
  int numplayers, level;

  numplayers = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (num_player_box));
  if (numplayers < 2) numplayers = 2;
  else if (numplayers > 4) numplayers = 4;
  level = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (level_box));
  if (level < 1) level = 1;
  else if (level > 9) level = 9;

  gconf_client_set_int(gcc, LXDOOM_NUMPLAYERS, numplayers, NULL);
  gconf_client_set_int(gcc, LXDOOM_LEVEL, level, NULL);
  gconf_client_set_bool(gcc, LXDOOM_NOMONSTER, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nomonster_check)), NULL);
  gconf_client_set_bool(gcc, LXDOOM_DEATHMATCH, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (deathmatch_check)), NULL);
}

static void
set_multiplayer_data(gchar *nick, gchar *ip) {
  gconf_client_set_bool(gcc, LXDOOM_CREATESERVER, TRUE, NULL);
  gconf_client_set_string(gcc, LXDOOM_SERVERIP, ip, NULL);
}

static StartupPluginInfo plugin_info = {
  load_plugin,
  NULL,
  write_config,
  NULL,
  NULL,
  NULL,
  set_multiplayer_data
};

STARTUP_INIT_PLUGIN(plugin_info, gs, FALSE, FALSE)
