/*
 * Copyright (C) 2008 Andrew Olmsted, all rights reserved.
 *
 * Contact: Andrew Olmsted <andrew.olmsted@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef LARGE_STATUSBAR_CLOCK_HOURS_H
#define LARGE_STATUSBAR_CLOCK_HOURS_H

#include <glib-object.h>

/* For Status Bar plugins */
#include <libhildondesktop/hildon-status-bar-item.h>

G_BEGIN_DECLS

/* Common struct types declarations */
typedef struct _LargeStatusbarClockHoursPlugin LargeStatusbarClockHoursPlugin;
typedef struct _LargeStatusbarClockHoursPluginClass LargeStatusbarClockHoursPluginClass;
typedef struct _LargeStatusbarClockHoursPluginPrivate LargeStatusbarClockHoursPluginPrivate;

/* Common macros */
#define TYPE_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN            (large_statusbar_clock_hours_plugin_get_type ())
#define LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN, LargeStatusbarClockHoursPlugin))
#define LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  TYPE_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN, LargeStatusbarClockHoursPluginClass))
#define IS_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN))
#define IS_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  TYPE_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN))
#define LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  TYPE_LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN, LargeStatusbarClockHoursPluginClass))

/* Instance struct */
struct _LargeStatusbarClockHoursPlugin
{
	  HildonStatusBarItem* sbitem;
	  GtkWidget* button;
	  GtkWidget* hoursLabel;
	  gboolean ampm;
	  gboolean stacked;
	  gboolean alarm;
	  gchar* fontDesc;
	  gchar* fontColour;
	  osso_context_t* osso;
};

/* Class struct */
struct _LargeStatusbarClockHoursPluginClass
{
	  StatusbarItemClass parent_class;
};

GType  large_statusbar_clock_hours_plugin_get_type  (void);

G_END_DECLS

#endif /* LARGE_STATUSBAR_CLOCK_HOURS_PLUGIN_H */
