#!/bin/sh
# use gainroot to become root and relaunch itself
if [ `id -u` != 0 ] ; then
	#if not already root, call itself as root
	sudo gainroot <<EOF
exec $0
EOF
	exit
fi
# real script follows
#!/bin/sh

if [ -e "/usr/lib/hildon-desktop/liblarge_statusbar_clock_minutes.so" ]
then
	echo "Removing old files..."
	rm -f /usr/share/applications/hildon-status-bar/large-statusbar-clock-minutes.desktop
	rm -f /usr/lib/hildon-status-bar/liblarge_statusbar_clock_minutes.so
fi
if [ -e "/usr/lib/hildon-desktop/liblarge_statusbar_clock_hours.so" ]
then
	echo "Removing old files..."
	rm -f /usr/share/applications/hildon-status-bar/large-statusbar-clock-hours.desktop
	rm -f /usr/lib/hildon-status-bar/liblarge_statusbar_clock_hours.so
fi

echo "Putting files in their place..."
cp liblarge_statusbar_clock_minutes.so /usr/lib/hildon-status-bar/
cp large-statusbar-clock-minutes.desktop /usr/share/applications/hildon-status-bar/
cp liblarge_statusbar_clock_hours.so /usr/lib/hildon-status-bar/
cp large-statusbar-clock-hours.desktop /usr/share/applications/hildon-status-bar/
cp large-statusbar-clock.conf /etc/osso-backup/applications/
cp large-statusbar-clock-alarm.png /usr/share/pixmaps/

echo "Changing necessary permissions..."
chown root.root /usr/lib/hildon-status-bar/liblarge_statusbar_clock_minutes.so
chown root.root /usr/share/applications/hildon-status-bar/large-statusbar-clock-minutes.desktop
chown root.root /usr/lib/hildon-status-bar/liblarge_statusbar_clock_hours.so
chown root.root /usr/share/applications/hildon-status-bar/large-statusbar-clock-hours.desktop

echo "Done!"
